/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMIdentifier.m,v 1.4 1998/01/05 01:13:05 tiggr Exp $  */

#import "OTMIdentifier.h"
#import "OTMMeta.h"

int num_identifiers;

TLSet *ident_trace_objects;

@implementation OTMIdentifier

+gcAlloc
{
  OTMIdentifier *ident = [super gcAlloc];
  num_identifiers++;

  if (flag_trace_identifiers)
    {
      if (!ident_trace_objects)
	{
	  ident_trace_objects = [TLSet new];
	  [ident_trace_objects gcLock];
	}

      [ident_trace_objects addElement: ident];
    }

  return ident;
}

-(id) resolveInContext: (OTMMeta *) current
{
  id r = [current searchEntityNamed: name
	  supers: YES class: YES variables: YES constants: YES];

  num_identifiers--;

  if (flag_trace_identifiers)
    [ident_trace_objects removeElement: self];

  if (r)
    return r;

  error_for (self, @"undeclared variable `%@'", name);
  return self;
}

@end
