/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMITE.m,v 1.18 1998/01/05 01:13:03 tiggr Exp $  */

#define OTMITE_DECLARE_PRIVATE_METHODS
#import "OTMITE.h"
#import "OTMBasic.h"
#import "OTMCompound.h"
#import "global.h"

@implementation OTMITE

+(OTMITE *) iteWithCondition: (OTMExpr *) c
{
  OTMITE *e = [[self gcAlloc] initWithCondition: c];
  [e getLocationFrom: c];
  return e;
}

-(void) compile
{
  [ip compile];

  formac (of, @"%@if (%@)", [self nl], [ip result]);

  indent_level++;
  if (tp)
    [tp compile];
  else
    formac (of, @"%@;", [self nl]);
  indent_level--;

  if (ep)
    {
      formac (of, @"%@else", [ep nl]);
      indent_level++;
      [ep compile];
      indent_level--;
    }
}

-(void) gcReference
{
  MARK (ip);
  MARK (tp);
  MARK (ep);

  [super gcReference];
}

-initWithCondition: (OTMExpr *) c
{
  [super init];

  ip = c;

  return self;
}

-(id) precompile
{
  int previous_line = current_line;

  current_line = line_number;
  ip = [ip elaborate];
  current_line = previous_line;

  ip = [ip precompile];
  tp = [tp precompile];
  if (ep)
    ep = [ep precompile];

  return self;
}

-(void) setIf: (OTMExpr *) i
{
  ASGN_IVAR (ip, i);
}

-(void) setThen: (OTMCompound *) t
{
  ASGN_IVAR (tp, t);
}

-(void) setElse: (OTMCompound *) e
{
  ASGN_IVAR (ep, e);
}

@end
