/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMExpr.m,v 1.33 1998/01/22 17:27:49 tiggr Exp $  */

#define OTMEXPR_DECLARE_PRIVATE_METHODS
#import "OTMExpr.h"
#import "OTMBasic.h"
#import "OTMTuple.h"
#import "OTMType.h"

@implementation OTMExpr

-(void) compile
{
  /* Nothing to do.  */
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  if (self != any_type_expr)
    error_for (self, @"invalid lhs (should have been caught earlier)");
}

-(void) compileAssignmentToTuple: (OTMTuple *) lhs
{
  // This should not be necessary...
  // Fri Feb 28 15:23:34 1997, tiggr@tricky.es.ele.tue.nl
  if ([[lhs elements] length] == 1)
    [self compileAssignment: [[lhs elements] _elementAtIndex: 0]];
  else
    error_for (self, @"invalid rhs (should have been caught earlier)");
}

-(void) declareReturnArguments: (int) n
{
}

-(int) flatElementCount
{
  return type == basic_type[BT_VOID] ? 0 : 1;
}

-(void) gcReference
{
  MARK (type);

  [super gcReference];
}

-(id) initWithType: (OTMType *) t
{
  if (![super init])
    return nil;

  type = (id) t;

  return self;
}

-(BOOL) isTuple
{
  return NO;
}

-(OTMExpr *) lhsInvalid
{
  return self == any_type_expr ? nil : self;
}

-(id <TLString>) exprName
{
  return @"*** otmexpr unimplemented name ***";
}

-(id) oldsEliminated
{
  return self;
}

-(id) conditionCopyFor: (OTMCustomMethod *) method
{
  return (self);
}

-(id) precompile
{
  if (type)
    type = [type precompile];

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  return default_resolve_expr (type, expected, to, cxt, indices, index);
}

-(void) setType: (id) t
{
  ASGN_IVAR (type, t);
}

-(OTMType *) type
{
  return (id) type;
}

-(OTMExpr *) tupleSingleElement
{
  return self;
}

-(id <TLString>) result
{
  [self subclassResponsibility: _cmd];
}

-(id) outputReference
{
  [self subclassResponsibility: _cmd];
}

-(BOOL) checkProperArgument: (OTMMethod *) m
{
  [self subclassResponsibility: _cmd];
}

@end
