/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCondExpr.m,v 1.23 1998/01/05 01:12:34 tiggr Exp $  */

#define OTMCONDEXPR_DECLARE_PRIVATE_METHODS
#import "OTMCondExpr.h"
#import "OTMBasic.h"
#import "OTMCompound.h"
#import "OTMITE.h"
#import "OTMType.h"
#import "global.h"

@implementation OTMCondExpr

+(OTMCondExpr *) iteWithCondition: (OTMExpr *) c
			 thenPart: (OTMExpr *) t
			 elsePart: (OTMExpr *) e
{
  OTMCondExpr *expr;
  expr = [[self gcAlloc] initWithCondition: c thenPart: t elsePart: e];
  [expr getLocationFrom: c];
  return expr;
}

-(void) gcReference
{
  MARK (ip);
  MARK (tp);
  MARK (ep);
  MARK (possible_types);

  [super gcReference];
}

-initWithCondition: (OTMExpr *) c
	  thenPart: (OTMExpr *) t
	  elsePart: (OTMExpr *) e
{
  [super initWithType: nil];

  ip = c;
  tp = t;
  ep = e;

  return self;
}

-(id) elaborate
{
  id previous_compound = current_compound;
  int previous_line = current_line;
  OTMITE *ite;
  OTMExpr *result;

  /* Enforce our own line.  */
  current_line = line_number;
  ite = [CO_OTMITE iteWithCondition: ip];

  if (!type)
    ABORT ();

  if (type != basic_type[BT_VOID])
    result = temp_something_with_type (type, 1);
  else
    result = nil;

  if (tp)
    {
      current_line = [tp line];
      current_compound = [CO_OTMCompound
			  compoundWithContainer: previous_compound];
      tp = [tp elaborate];
      emit_statement (tp);
      if (result)
	{
	  emit_assignment (result, [tp value]);
	  [current_compound setValue: result];
	}
      [ite setThen: current_compound];
      current_compound = nil;
    }

  if (ep || result)
    {
      current_line = [ep line];
      current_compound = [CO_OTMCompound
			  compoundWithContainer: previous_compound];
      if (ep)
	{
	  [current_compound getLocationFrom: ep];
	  ep = [ep elaborate];
	  emit_statement (ep);
	  if (result)
	    {
	      emit_assignment (result, [ep value]);
	      [current_compound setValue: result];
	    }
	}
      else
	emit_assignment (result, nil_something_with_type ([tp type]));

      [ite setElse: current_compound];
    }

  current_compound = previous_compound;
  current_line = previous_line;

  emit_statement (ite);

  return result ? result : void_expr;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  TLCons *post, *pose = nil, *pos;

  if (type)
    return [super resolveWithExpected: expected convertible: to
		  context: cxt indices: indices index: index];

  if (![ip type])
    ip = resolve_expr (ip, CONS (basic_type[BT_BOOLEAN], nil), nil, cxt);

  post = [tp resolveWithExpected: expected convertible: to
	     context: cxt indices: indices index: index];
  if (!ep)
    pos = post;
  else
    {
      pose = [ep resolveWithExpected: expected convertible: to
		 context: cxt indices: indices index: index];
      pos = types_intersect (post, pose, expected);
    }

  if (pos && ![pos cdr] && [[pos car] isFullyDefinedType])
    {
      type = [[pos car] typeAt: index in: indices];
      if (![tp type])
	post = [tp resolveWithExpected: pos convertible: nil
		   context: cxt indices: indices index: index];
      if (ep)
	{
	  if (![ep type])
	    pose = [tp resolveWithExpected: pos convertible: nil
		       context: cxt indices: indices index: index];
	  pos = types_intersect (post, pose, expected);
	}
    }
  else if (!pos)
    {
      /* It is okay if the types in the branches do not match, but then
         we've become a void expression.  */
      type = basic_type[BT_VOID];
      if (!expected)
	pos = CONS (type, nil);
      else
	{
	  OTMType *t = types_element_of (type, expected, cxt,
					 indices, index, 1);

	  if (t)
	    pos = CONS (t, nil);
	}

      if (tp && ![tp type])
	tp = resolve_expr (tp, nil, nil, cxt);
      if (ep && ![ep type])
	ep = resolve_expr (ep, nil, nil, cxt);
    }

  return pos;
}

-(void) setIf: (OTMExpr *) i
{
  ASGN_IVAR (ip, i);
}

-(void) setThen: (OTMCompound *) t
{
  ASGN_IVAR (tp, t);
}

-(void) setElse: (OTMCompound *) e
{
  ASGN_IVAR (ep, e);
}

@end
