/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCatch.m,v 1.12 1998/01/05 01:12:25 tiggr Exp $  */

#define OTMCATCH_DECLARE_PRIVATE_METHODS
#import "OTMCatch.h"
#import "OTMBasic.h"

@implementation OTMCatch

+(OTMCatch *) catchWithTag: (OTMExpr *) t container: (OTMCompound *) c
{
  return [[self gcAlloc] initWithTag: t container: c];
}

-(void) compileCondition: (BOOL) end_not_start
{
  if (!end_not_start)
    {
      id <TLString> fn = ([result type] == basic_type[BT_VOID]
			  ? @"" : [[result type] frobnicatedName]);
      LTTSelArgTypes *rd = [CO_LTTSelArgTypes argumentTypesWithString: fn];
      int n = [result flatElementCount];

      formac (of, @"%@/* BEGIN START OF CATCH  */"
	      @"%@jmp_buf _catch_buf;%@if (!setjmp (_catch_buf))%@{",
	      [self nl], [self nl], [self nl], [self nl]);
      indent_level++;

      formac (of, @"%@struct trt_catch *_catch_info = alloca (sizeof "
	      @"*_catch_info + %d * sizeof _catch_info->values[0]);",
	      [self nl], n);

      formac (of, @"%@_catch_info->c.kind = TRT_CONDITION_KIND_CATCH;",
	      [self nl]);
      [tag compile];
      formac (of, @"%@_catch_info->tag = %@;", [self nl], [tag result]);
      formac (of, @"%@_catch_info->jmp = &_catch_buf;", [self nl]);
#if STACK_REF_STRUCT
      formac (of, @"%@_catch_info->sp = %@;", [self nl], TO_TRT_PROTECT_STACK);
#endif
      formac (of, @"%@_catch_info->value_desc = &%@;",
	      [self nl], [rd outputDefinitionName]);

      if (n)
	{
	  if (n != 1)
	    ABORT (); /* XXX Closures would be nice here...  */

	  formac (of, @"%@_catch_info->values[0] = &%@;",
		  [self nl], [result outputReference]);
	}

      formac (of, @"%@trt_register (&_catch_info->c);", [self nl]);
      formac (of, @"%@/* FINISH START OF CATCH  */", [self nl]);
    }
  else
    {
      formac (of, @"%@/* BEGIN END OF CATCH  */", [self nl]);
      formac (of, @"%@trt_unwind (&_catch_info->c);", [self nl]);
      indent_level--;
      formac (of, @"%@}", [self nl]);
      formac (of, @"%@/* FINISH END OF CATCH  */", [self nl]);

    }
}

-(void) gcReference
{
  MARK (tag);

  [super gcReference];
}

-(id) initWithTag: (OTMExpr *) t container: (OTMCompound *) c
{
  [super initWithContainer: c];

  tag = t;

  return self;
}

-(id) precompile
{
  id <TLString> fn = ([result type] == basic_type[BT_VOID]
		      ? @"" : [[result type] frobnicatedName]);
  LTTSelArgTypes *rd = [CO_LTTSelArgTypes argumentTypesWithString: fn];

  /* XXX This is wrong, since the information should be output to the .i
     file as well.  For now, we just hope that some method somewhere in
     every program being resolved, will incorporate a method with
     arguments of the same type as this tuple we're returning...
     Fri May  3 16:19:45 1996,  --Tiggr.  */
  formac (of, @"%@extern struct trtd_selector_args %@;",
	  [self nl], [rd outputDefinitionName]);

  return [super precompile];
}

@end
