<copyright> Type descriptions.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: TypeDescription.t,v 1.10 1998/01/05 01:07:24 tiggr Exp $</id>
    </copyright>

implementation class
TypeDescription: State
{
  <doc> A container holding the mapping from {struct trtd_selector_args}
      to a {TypeDescription} instance.  </doc>
  static MutablePointerDictionary descriptions;
}

<doc> Designated allocator, using a cache.  </doc>
instance (id) (result)
  for pointer args
{
  if (!descriptions)
    {
      descriptions = [MutablePointerDictionary new];
      [descriptions setIsContainer YES];
    }
  else
    result = descriptions[args];

  if (!result)
    descriptions[args] = result = [[self alloc] init args];
}

end;

implementation instance
TypeDescription
{
  <doc> The internal runtime structure to the type description.  </doc>
  public pointer types_description;
}

extern boolean
  equal id other;

<doc> Designated initializer.  </doc>
protected id (self)
  init pointer args
{
  types_description = args;
}

<doc> Return the number of elements.  </doc>
extern int
  length;

<doc> Describe the element at {n}, indexed 0.  This returns one of the
    {TYPEDESC_*} {Constants}.  </doc>
extern int
  component int n;

<doc> Describe the component types.  </doc>
OutputStream
  writeFields OutputStream s
{
  int i, n = [self length];

  s = [s print (" ", n, " (")];
  for (i = 0; i < n; i++)
    s = [s print (i == 0 ? "" : " ", [self component i])];
  = [s print ")"];
}

end;
