<copyright> Queue and ObjectQueue classes.
    Written by <a href="mailto:tiggr@gerbil.org">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996-1999 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Queue.t,v 1.9 1999/09/13 12:13:09 miro Exp $</id>
    </copyright>

/******************** Queue ********************/

<doc> The abstract Queue class. There is not much you can do with it as
    queue has to be mutable to do anything useful.  </doc>
implementation class
Queue: Indexed

end;

implementation instance
Queue

<doc> Return TRUE.  </doc>
boolean
  queuep
{
  = TRUE;
}

<doc> Return TRUE for empty queues. </doc>
deferred boolean
  emptyp;

end;

/******************** MutableQueue ********************/

implementation class
MutableQueue: Queue, MutableIndexed

end;

implementation instance
MutableQueue

<doc> Push an object to the head of the queue.  </doc>
deferred void
  add Any object;

<doc> Pop the object from the tail of the queue.  </doc>
deferred Any
  pop;

end;

/******************** MutableObjectQueue ********************/

implementation class
MutableObjectQueue: MutableQueue, Conditions

end;

implementation instance
MutableObjectQueue
{
  <doc> The index into the {contents} of the element {self[0]}.  </doc>
  int offset;

  <doc> The number of elements.  </doc>  
  int elements;

  <doc> The array holding the actual objects.  </doc>
  MutableObjectArray contents;
}

Any
  at int index
pre
  index >= 0 && index < elements
{
  = [contents at (index + offset) % [contents length]];
}

void
  set All object
   at int index
pre
  index >= 0 && index < elements
{
  [contents set object
	    at (index + offset) % [contents length]];
}

int
  length
{
  = elements;
}

<doc> Add the {object} to the end.  </doc>
void
  add Any object
{
  int len = [contents length];

  if (elements == len)
    {
      [contents resize ((offset + len - 1) % len, len)];
      len = [contents length];
    }

  self[++elements] = object;
}

boolean
  emptyp
{
  = elements <= 0;
}

<doc> Retrieve the object at {self[0]} and remove it.  All in constant
    time, of course.  </doc>
Any
  pop
{
  if ([self emptyp])
    {
      [[Condition for self class warning message "Empty queue"] signal];
      return nil;
    }

  Any result = self[0];
  elements--;
  offset++;

  /* Bump over to zero - this is the basis of a circular
     array datastructure */
  if (offset > [contents length])
    offset = 0;

  = result;
}

<doc> Make the queue empty.  </doc>
id (self)
  empty
{
  elements = offset = 0;

  /* Init with larger capacity to avoid unnecessary reallocing for
     a reasonably small queues */
  contents = [[MutableObjectArray alloc] initWithCapacity 64];
}

end;
