<copyright> InvocationResult class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: InvocationResult.t,v 1.12 1998/01/05 01:06:26 tiggr Exp $</id>
    </copyright>

implementation class
InvocationResult: State, Constants

<doc> Return a freshly allocated instance with the {result}, which is a
    {struct trt_invocation_result}.  </doc>
protected instance (id)
  with pointer result
{
  = [[self alloc] init result];
}

end;

implementation instance
InvocationResult
{
  <doc> The actual result.  </doc>
  pointer values;
}

<doc> Designated initializer.  </doc>
protected id
  init pointer result
{
  values = result;

  // Is this true?
  // Sun Jan  5 15:26:07 1997, tiggr@tricky.es.ele.tue.nl
  /* This invocation of super is needed since we need a super reference to
     be created from {InvocationResult} to {State} for the coding methods,
     which are implemented in C.  */
  = [super init];
}

<doc> Retrieve all values from this result.  The expected return type must
    fully match the actual return type.  </doc>
extern dynamic
  components;

<doc> Retrieve the {n}th element from the result.  The index of the first
    element is 0.

    The expected return type must fully match, or can be an object, in
    which case numeric values are returned in a {Number} instance, and
    selectors in a {Selector}.  Pointer values on a mismatch cause a
    condition to be signaled.  </doc>
extern dynamic
  component int n;

<doc> Return the number of elements in this result.  </doc>
int
  length
{
  = [[self typeDescription] length];
}

<doc> From the values held by this {InvocationResult}, update the
    {builtin_return_type} value pointed to by {first_value}, and any extra
    return value pointers as pointed to by the {va_list} {extra_values}.
    </doc>
extern void
  setReturnValues (pointer, pointer) (first_value, extra_values)
      forSelector selector sel;

<doc> Return a the {TypeDescription} for this result.  </doc>
extern TypeDescription
  typeDescription;

<doc> Output the elements in this result.  </doc>
OutputStream
  writeFields OutputStream s
{
  TypeDescription desc = [self typeDescription];
  int i, n = [desc length];

  if (!n)
    return [s print " void"];

  for (i = 0; i < n; i++)
    {
      int t = [desc component i];

      s = [s print ' '];
      if (t == TYPEDESC_POINTER)
	{
	  pointer p = [self component i];
	  s = [s print p];
	}
      else
	{
	  All object = [self component i];
	  s = [s print object];
	}
    }

  = s;
}

/******************** private methods ********************/
<doc><h4>Private methods</h4></doc>

<doc> Free the {values}.  </doc>
extern void
  dealloc;

<doc> Mark the objects in this result.  </doc>
extern void
  gc_mark_elements;

/******************** coding ********************/
<doc><h4>Coding</h4></doc>

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [InvocationResult self]])
    {
      [super encodeUsingCoder coder];
      [self encodeToCoder coder];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [InvocationResult self]])
    {
      [super initWithCoder coder];
      [self decodeFromCoder coder];
    }
}

<doc> Private method to do the hard work of encoding all information
    carried by this result.  </doc>
protected extern void
  encodeToCoder Encoder coder;

<doc> Private method to do the hard work of decoding all information from
    the {coder} into this result.  </doc>
protected extern void
  decodeFromCoder Decoder coder;

end;
