<copyright> Invocations.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Invocation.t,v 1.20 1998/01/20 00:08:51 tiggr Exp $</id>
    </copyright>

<doc> An {Invocation} is an object holding a target object, a selector,
    and arguments to the selector.  Thus, an {Invocation} holds everything
    needed to send a message.  An {Invocation} can be fired at its target
    (with the {fire} method), or fired after retargeting (using the
    {fireAt} method).

    An {Invocation} is incomplete when not all arguments needed to send
    the message have been specified.  An incomplete {Invocation} can be
    fired in two different ways.  First, by invoking {fireWith} and
    supplying values for the remaining arguments.  Second, by invoking on
    the {Invocation} a method completing it.  For example, if an
    {Invocation} {x} of the method {void with int a do int b} only has a
    value for the argument {a}, then invoking {[x do 23]} will
    (temporarily) complete the {Invocation} and send the full message
    ({with do}) to its target.  </doc>
implementation class
Invocation: State

<doc> Create a, potentially incomplete, invocation.  </doc>
extern instance (id)
   for selector sel
   to: All target = nil
  with dynamic arguments;

<doc> Create a, potentially incomplete, invocation.  </doc>
extern instance (id)
  for selector sel
  to: All target = nil
    : Indexed arguments = nil;

<doc> Create a complete invocation.  This raises a {program-condition} if
    the resulting invocation is incomplete.  </doc>
extern instance (id)
    of selector sel
   to: All target = nil
  with dynamic arguments;

<doc> Create a complete invocation.  This raises a {program-condition} if
    the resulting invocation is incomplete.  </doc>
extern instance (id)
   of selector sel
  to: All target = nil
    : Indexed arguments = nil;

<doc> Create an invocation.  It shall be complete.  This method is
    primarily intended to be used by {Proxy} in its forwarding from
    {forwardSelector arguments}.

    Arguments are to be retrieved from the {va_list} pointed to by {ap},
    i.e. {va_arg (*ap, ...)}.  </doc>
extern instance (id)
     of selector sel
    to: All target = nil
  using pointer ap;

end;

implementation instance
Invocation
{
  <doc> The result of the most recent invocation, or {nil} if we haven't
      fired yet, or have fired with a void return type (of the fire
      method).  </doc>
  InvocationResult result;

  <doc> The underlying invocation structure.  </doc>
  pointer invocation;
}

<doc> Designated initializer.  </doc>
protected id
  init pointer i
{
  invocation = i;
  = self;
}

<doc> Return {TRUE} iff the receiving invocation is complete, i.e. is has
    all the arguments needed and can be fired directly with {fire} or
    {fireAt}.  </doc>
extern boolean
  isComplete;

<doc> Return this invocation's selector.  </doc>
extern selector
  selector;

<doc> Return this invocation's target.  </doc>
extern Any
  target;

/******************** forwarding ********************/
<doc><h4>Forwarding</h4></doc>

<doc> Forward the selector {sel} with the arguments pointed to by the
    {va_list} pointed to by {ap}.  Return the result of the invocation.

    Only the incoming arguments from {*ap} will be retrieved, so that
    subsequent {va_arg} invocations on {*ap} can retrieve the outgoing
    argument pointers.

    This method is invoked by the runtime library in an attempt to forward
    a message not directly implemented by the receiver.  This method is
    used since it is faster than a {forwardInvocation}.  </doc>
protected extern InvocationResult
  forwardSelector selector sel
	arguments pointer ap;

<doc> Return {YES}.  </doc>
boolean
  invocationp
{
  = YES;
}

/******************** performing ********************/
<doc><h4>Performing the invocation</h4></doc>

<doc> Perform the invocation.  If invoked repeatedly, the invocation will be
    performed repeatedly.  </doc>
extern InvocationResult
  fire;

<doc> Similarly, but avoid the creation of an {InvocationResult}.  The
    {result} of the receiving invocation is set to {nil}.  </doc>
extern void
  fire;

<doc> Perform the invocation after setting the receiver of this invocation
    to {target}.  </doc>
extern InvocationResult
  fireAt All target;

<doc> Similarly, but avoid the creation of an {InvocationResult}.  The
    {result} of the receiving invocation is set to {nil}.  </doc>
extern void
  fireAt All target;

<doc> Perform the invocation resulting from completing this invocation
    with the {arguments}.  Return the result.  The receiving invocation
    will remain incomplete.  </doc>
extern InvocationResult
  fireWith dynamic arguments;

<doc> Similarly, but avoid the creation of an {InvocationResult}.  The
    {result} of the receiving invocation is set to {nil}.  </doc>
extern void
  fireWith dynamic arguments;

<doc> Shortcut to fire and return the first element of the result as an
    object.  </doc>
Any
  objectAfterFire
{
  = [[self fire] component 0];
}

<doc> Shortcut to retrieve the first element of the result as an object.
    This fires if needed.  </doc>
Any
  objectOfResult
{
  = [[self result] component 0];
}

<doc> If the invocation has been fired at least once, return the (most
    recent) result.  Otherwise, fire and return the result.  </doc>
InvocationResult
  result
{
  = !result ? [self fire] : result;
}

<doc> Return the type description of the result from this invocation.  </doc>
extern TypeDescription
  resultTypeDescription;

/******************** coding ********************/
<doc><h4>Coding</h4></doc>

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [Invocation self]])
    {
      [super encodeUsingCoder coder];

      [self encodeToCoder coder];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [Invocation self]])
    {
      [super initWithCoder coder];

      [self decodeFromCoder coder];
    }
}

<doc> Private method to do the hard work of encoding all information
    carried by this invocation.  </doc>
protected extern void
  encodeToCoder Encoder coder;

<doc> Private method to do the hard work of decoding all information from
    the {coder} into the invocation.  </doc>
protected extern void
  decodeFromCoder Decoder coder;

/******************** gc methods ********************/
<doc><h4>Garbage collection methods</h4></doc>

<doc> Deallocate the structure underlying the invocation.  </doc>
extern void
  dealloc;

<doc> Mark the objects in this invocation's arguments.  </doc>
extern void
  gc_mark_elements;

end;
