<copyright> IntDictionary and MutableIntDictionary classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: IntDictionary.t,v 1.14 1998/03/30 11:29:26 tiggr Exp $</id>
    </copyright>

/******************** IntDictionary ********************/

<doc> A {IntDictionary} maps an {int} to an object reference.  </doc>
implementation class
IntDictionary: HashTable

end;

implementation instance
IntDictionary

Any
  at int key
{
  int bucket = key * GOLDEN_BITS >>> (32 - size_shift);
  BucketIntDictElement elt = buckets[bucket];

  = !elt ? nil : [elt member key];
}

<doc> Return a {valueEnumerator}.  </doc>
Enumerator
  enumerator
{
  = [self valueEnumerator];
}

<doc> Return an Enumerator on the values stored in this dict.  </doc>
Enumerator
  valueEnumerator
{
  = [DictionaryValueEnumerator with buckets];
}

end;

/******************** MutableIntDictionary ********************/

implementation class
MutableIntDictionary: IntDictionary, HashTableContainer

end;

implementation instance
MutableIntDictionary

void
  freeze
{
  // Freeze must employ a special setup where the state introducing class
  // is a superclass of the method introducing class, since the memory
  // layout may not change because of the freeze.  This is true for all
  // collections.  Given this can not be guaranteed, it should not be
  // allowed.
  // Fri Feb 28 18:22:17 1997, tiggr@akebono.ics.ele.tue.nl

  // It could employ set_kind...
  // Mon Mar 30 13:25:23 1998, tiggr@gerbil.org
  [self unimplemented cmd];
}

<doc> Remove the mapping for the {key}.  </doc>
void
  remove int key
{
  int inc = 1, bucket = key * GOLDEN_BITS >>> (32 - size_shift);
  BucketIntDictElement bucket_elt = buckets[bucket];

  if (!!bucket_elt)
    {
      BucketIntDictElement ne;
      int delta;

      (ne, delta) = [bucket_elt remove key];

      if (ne != bucket_elt)
	buckets[bucket] = ne;

      length -= delta;
    }
}

<doc> Associate the {value} with the {key}.  </doc>
void
  set All value
   at int key
pre
  value != nil
{
  int inc = 1, bucket = key * GOLDEN_BITS >>> (32 - size_shift);
  BucketIntDictElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketIntDictElement alloc] initWith (key, value)];
  else
    inc = [bucket_elt add (key, value)];

  if (inc != 0)
    [self adjust_length inc];
}

end;
