<copyright> Extension class.
    Written by <a href="mailto:tiggr@gerbil.org">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996-1999 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Extension.t,v 1.11 1999/09/11 12:27:57 tiggr Exp $</id>
    </copyright>

implementation class
Extension: State, Conditions
{
  <doc> All extensions, here to be protected against gc.  </doc>
  static MutableArray extensions;
}

<doc> Designated allocator.  Do not use {alloc} or plain {new}.  </doc>
instance (id)
  new pointer p
{
  if (!extensions)
    extensions = [MutableObjectArray new];

  Extension r = [[self alloc] init p];
  [extensions add r];

  = r;
}

end;

implementation instance
Extension
{
  <doc> The runtime structure describing this extension.  </doc>
  pointer rti;

  <doc> The names of this extension's variables.  </doc>
  Indexed var_names;
}

<doc> An {Extension} should never be deallocated.  This method raises,
    which is a panic during garbage collection...  </doc>
void
  dealloc
{
  [[Condition for self class program-condition
	      message "dealloc considered harmful"] raise];
}

<doc> Return {YES} if this extension provides an implementation for the
    selector {sel}.  </doc>
extern boolean
  implements selector sel;

<doc> Designated initializer.  </doc>
protected id (self)
  init pointer r
{
  rti = r;
}

<doc> Return the class object to which this extension belongs.  </doc>
extern class (State)
  meta;

<doc> Return the name of this extension.  </doc>
extern String
  name;

<doc> Return the names of the variables in this extension.  </doc>
extern Indexed
  variables;

extern int
  typeOfVariableNamed String name
		   in All object;

extern Any
  valueOfVariableNamed String name
		    in All object;

extern void
	 setValue dynamic value
  ofVariableNamed ByteString name
	       in All object;

OutputStream
  writeFields OutputStream s
{
  = [s print (" name=", [self name], " class=", [self meta])];
}

/******************** perform ********************/

<doc> The equivalent of {perform with} where the method invoked is defined
    by this extension instead of the receiving object.  Obviously, the
    {object} should actually have this extension as one of its extensions,
    i.e. {[object isKindOf [self meta]]} should be a precondition (and a
    postcondition too, but we're not interested after the fact).  </doc>
extern dynamic
  perform selector sel
       on All object
     with dynamic arguments;

extern dynamic
  perform selector sel
       on All object
	: Array arguments = nil;

end;
