<copyright> EqSet and MutableEqSet classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: EqSet.t,v 1.19 1998/01/05 01:05:57 tiggr Exp $</id>
    </copyright>

implementation class
EqSet: Set, EqHashTable

end;

implementation instance
EqSet

/********** Keyed **********/

end;

implementation class
MutableEqSet: EqSet, MutableEqHashTable, MutableSet, Container

end;

implementation instance
MutableEqSet

<doc> Retrieve a (any) object from the set.  This removes an element from
    the set and returns it.  </doc>
//Any
//  retrieve;

/********** MutableKeyed **********/

<doc> Add the {object} to the receiving set.  </doc>
void
  add All object
{
  int inc = 1, bucket = [object hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketSetElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketSetElement alloc] initWith object];
  else
    inc = [bucket_elt addq object];

  if (inc != 0)
    [self adjust_length inc];
}

<doc> Remove {elt} from the receiving set, if present.  </doc>
void
  remove All object
{
  int bucket = [object hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketSetElement bucket_elt = buckets[bucket];

  if (bucket_elt != nil)
    {
      BucketSetElement new_bucket_elt;
      int decrease;

      (new_bucket_elt, decrease) = [bucket_elt removeq object];
      if (decrease != 0)
	{
	  // Should we shrink?
	  // Mon Dec  1 13:57:34 1997, tiggr@natlab.research.philips.com
	  length -= decrease;
	  if (new_bucket_elt != bucket_elt)
	    buckets[bucket] = new_bucket_elt;
	}
    }
}

<doc> This method is invoked by the garbage collector to have the set
    containing all containers make those containers mark their elements.
    This method relies on the container containing the containers be
    itself a container.  </doc>
void
  gc_mark_containers
pre
  [self isContainer]
{
  int i, n = 1 << size_shift;

  /* We can't use makeElementsPerform here since it is not the elements
     which must perform the operation, but the bucket objects.  */
  for (i = 0; i < n; i++)
    {
      BucketSetElement elt = buckets[i];
      if (elt != nil)
	// What about the changing count of objects?
	// Mon Jul 28 16:25:26 1997, tiggr@cobra.ics.ele.tue.nl
	[elt gc_mark_containers];
    }
}

end;
