<copyright> Conditions.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Conditions.t,v 1.21 1998/05/17 22:53:44 tiggr Exp $</id>
    </copyright>

<doc> The {Conditions} class is an instance-less non-static-state-less
    class providing predefined conditions.  Not-predefined, i.e. user
    defined, conditions should be made available to the world through an
    extension of {Conditions}.  </doc>
implementation class
Conditions
{
  <doc> The object informed of unhandled condition raises.  Iff {nil}, the
      program aborts when a condition being raised is not handled.  </doc>
  static All unhandled_condition_handler;

  <doc> The selector of the message to be sent to the
      {unhandled_raise_handler}.  This method accepts a single argument,
      which will be a {Condition}.  </doc>
  static selector unhandled_condition_selector;

  // Should teach gi about indentation like this.
  // Thu May  2 01:36:14 1996, --Tiggr
  <doc> Various (and numerous) condition classes, indented according to
      condition inheritance.  </doc>
  static ConditionClass
    condition,
      warning,
      unimplemented,
      encoding-condition,
      serious-condition,
	runtime-condition,
	  runtime-fatal,
	  nil-receiver,
	  unrecognized-selector,
          uncaught-throw,
        program-condition,
	  unknown-class-condition,
	  coding-condition,
	  type-condition,
	  lock-condition,
	  condition-condition,
        error,
	  file-error,
	  stream-error,
	    stream-eos,
      signal-condition,
        signal-hup,
	signal-int,
	signal-bus,
	signal-segv;
}

end;

implementation instance
Conditions
end;
