<copyright> Bundle class, modeled after NeXT's Objective-C NSBundle.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Bundle.t,v 1.20 1999/07/15 21:54:39 tiggr Exp $</id>
    </copyright>

implementation class
Bundle: State, Constants, Runtime
{
  // CCC When this says `instance (id)', it is typed wrongly in the
  // context of Bundle instances referring `main'.
  // Wed Oct 30 17:04:23 1996, tiggr@jaguar.ics.ele.tue.nl
  <doc> The main bundle, i.e. the bundle describing the program and the
      units.  </doc>
  static Bundle main;

  <doc> The path as registered by the units.  </doc>
  static MutableIndexed units_path;
}

OutputStream (s)
  help OutputStream s
  done MutableKeyed done
{
  class (State) cls = [Bundle self];

  if (!done[cls])
    {
      [done add cls];

      s = [[s print "tom.Bundle
  :main-bundle-dir dir  indicate different main bundle dir
  :extend file          load unit in FILE before invoking main"] nl];
    }

}

// All this just because constructors suck, even with languages that
// implement them...
// Mon Feb 23 13:31:46 1998, tiggr@gerbil.org
<doc> Load the {object}, returning the underlying operating system handle
    upon success, or the NULL pointer upon failure.  An {error} is
    signaled in case of the latter.  The {unit} is the name of the unit
    supposedly contained in the {object}.  This unit, when present, will
    be resolved.  </doc>
private extern pointer
  load String object
  unit String unit;

<doc> Load the {unit} from the {object}.  </doc>
pointer
    loadUnit String unit
  fromObject String object
{
  pointer p = [self load object unit unit];

  if (!!p)
    {
      String full = [File express-filename [File directory-of-file object]
			  relative-to [File current_directory]];
      [units_path add full];
    }

  = p;
}

<doc> Derive the unit name from the {object} name and invoke {loadUnit
    fromObject}.  </doc>
pointer
  load String object
{
  String bn = [File basename object];
  int i, n = [bn length];

  /* Fail for files starting with `.'.  */
  for (i = 0; i < n; i++)
    if (bn[i] == '.')
      {
	bn = [bn substring (0, i)];
	break;
      }

  = [self loadUnit bn fromObject object];
}

<doc> Accept {:main-bundle-dir} option and allocate the {main} bundle if
    found.  </doc>
void
  load MutableArray arguments
{
  int i, n = [arguments length];
  String main_bundle_dir;

  [self registerUnitDirectory nil];

  for (i = 0; i < n; i++)
    {
      ByteString a = arguments[i];
      String s;

      if ([a length] > 0 && a[0] == ':')
	if ([":main-bundle-dir" equal a])
	  {
	    main_bundle_dir = arguments[i + 1];
	    [arguments removeElements (i, 2)];
	    n -= 2;
	  }
	else if ([":extend" equal a])
	  {
	    String f = arguments[i + 1];
	    [arguments removeElements (i, 2)];
	    n -= 2;
	    [self load f];
	  }
    }

  if (main_bundle_dir != nil)
    main = [[self alloc] init [File filename-as-directory main_bundle_dir]];
}

<doc> Forward this to the main bundle.  </doc>
String
    locate-file String file
      extension String ext
  with-version: String version = nil
{
  = [[self main] locate-file file extension ext with-version: version];
}

<doc> Return the main bundle, creating it iff necessary.  </doc>
instance (id)
  main
{
  if (!main)
    {
      String lpn = long_program_name;

      if (!units_path)
	[self registerUnitDirectory nil];

      if (lpn[0] != '/'
	  && ({int l; (, l) = [lpn rangeOfString "/"]; l != -1;}))
	{
	  String path_string = [Runtime environment]["PATH"];

	  if (path_string != nil)
	    {
	      Indexed path = [path_string componentsSeparatedBy ':'];
	      String full = [File locate-file lpn along-path path];

	      if (full != nil)
		lpn = full;
	    }
	}

      main = [[self alloc] init [File directory-of-file lpn]];
    }

  = main;
}

<doc> Register the {dir} as to contain resources for one of the units.
    </doc>
void
  registerUnitDirectory String dir
{
  if (!units_path)
    {
      units_path = [MutableObjectArray new];
      [units_path add [Runtime main_resource_dir]];
    }

  if (dir != nil)
    [units_path add dir];
}

end;

implementation instance
Bundle
{
  <doc> The directory.  </doc>
  public String directory;

  <doc> Iff not the null pointer, the handle (in the underlying operating
      system) to the code loaded for this bundle.  Iff it is the null
      pointer, the code has not (yet) been loaded.  </doc>
  pointer handle;
}

id (self)
  init String d
{
  directory = d;
}

<doc> Locate the {file} for the {version} in this bundle.  If not found,
    search the main bundle.  Iff still not found, it is searched for in
    the registered unit directories.

    The extension {ext}, if not {nil}, is appended to the {file}, with a
    dot ({.}) in between.  </doc>
String
    locate-file String file
      extension String ext
  with-version: String version = nil
{
  String found;

  if (ext != nil)
    {
      MutableByteString b = [MutableByteString new];

      [b print (file, ".", ext)];
      [b freeze];
      file = b;
    }

  // Search in this bundle...
  // Wed Oct 30 16:21:23 1996, tiggr@jaguar.ics.ele.tue.nl

  if (self != main)
    found = [main locate-file file extension nil with-version: version];
  else
    found = [File locate-file file along-path units_path];

  = found;
}

end;
