/* Predicates.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: predicates.h,v 1.1 1998/01/08 16:13:51 tiggr Exp $  */

#define CONSP(X)  ({id _x = (X); _x && [_x consp];})
#define EMPTYP(X)  ({id _x = (X); STACKP (_x) && [_x emptyp];})
#define FLOATP(X)  ({id _x = (X); _x && [_x floatp];})
#define INTEGERP(X)  ({id _x = (X); _x && [_x integerp];})
#define LAMBDAP(X)  ({id _x = (X); _x && [_x lambdap];})
#define LISTP(X)  ({id _x = (X); !_x || [_x consp];})
#define NILP(X)  ({id _x = (X); !!_x;})
#define SEQUENCEP(X)  ({id _x = (X); !_x || [_x sequencep];})
#define STACKP(X)  ({id _x = (X); _x && [_x stackp];})
#define STRINGP(X)  ({id _x = (X); _x && [_x stringp];})
#define STREAMP(X)  ({id _x = (X); _x && [_x streamp];})
#define SUBROUTINEP(X)  ({id _x = (X); _x && [_x subroutinep];})
#define SYMBOLP(X)  ({id _x = (X); _x && [_x symbolp];})

#ifdef DECLARE_PREDICATE_METHODS
-consp;
-emptyp;
-floatp;
-integerp;
-lambdap;
-listp;
-nilp;
-sequencep;
-stackp;
-stringp;
-streamp;
-subroutinep;
-symbolp;

#else

#import "tl/TLPatchedRoots.h"

#endif
