/* Interface to TLStack class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStack.h,v 1.1 1998/01/08 16:13:36 tiggr Exp $  */

#ifdef TLSTACK_DECLARE_PRIVATE_METHODS
#define TLVECTOR_DECLARE_PRIVATE_METHODS
#endif

#import "TLVector.h"

@interface TLStack: TLVector

/******************** creation ********************/

+(TLStack *) stack;
+(TLStack *) stackWithCapacity: (int) c;
+(TLStack *) stackWithElements: (int) n, ...;

/******************** enumeration ********************/

/* Return an enumerator starting at TOS.  */
-(id <TLEnumerator>) enumerator;

/* Return an enumerator ending at TOS.  */
-(id <TLEnumerator>) reverseEnumerator;

/******************** manipulation ********************/

-(id) push: (id) o;
-(id) pop;
-(id) top;

/******************** predicates ********************/

-(id) stackp;
-(id) emptyp;

@end
