/* Interface to TLLLex class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLLex.h,v 1.1 1998/01/08 16:13:23 tiggr Exp $  */

#import "TLStream.h"
#import "TLString.h"

@class TLSymbol;

/* The symbol returned by a lexer upon reaching EOF.  */
extern TLSymbol *Qlex_eof;

@interface TLLLex: TLObject
{
  /* The input stream for this lexer.  */
  id <TLInputStream> stream;

  /* Input read buffer.  */
  char *buf;

  /* Position for next character in BUF and its capacity.  */
  char *next, *end;

  /* The current line.  */
  int line;

  /* The next character.  Maybe ungetting characters should be implemented
     by the stream protocol.  */
  int nch;
}

+(TLLLex *) lexerWithStream: (id <TLInputStream>) s;
+(TLLLex *) lexerWithString: (id <TLString>) s;

-initWithStream: (id <TLInputStream>) s;

/* Return the current line.  */
-line;

/* Return the next Lisp expression read from the stream.  Return Qlex_eof
   upon EOF or error.  */
-read;

/* Return this lexer's stream.  Useful for error reporting.  */
-(id <TLInputStream>) stream;

@end
