/* TL client garbage collection routines.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLGC.h,v 1.1 1998/01/08 16:13:16 tiggr Exp $  */

#import "TLObject.h"

/* Garbage protection from the stack.  Thank you Emacs.  */
struct tlgcs
{
  struct tlgcs *next;
  id *v;
  int n;
};

/* The list protecting objects pointed to from the stack.  */
extern struct tlgcs *_tlgc_stack;

#define GCDECL1 struct tlgcs _gcpro1
#define GCPRO1(V)  \
  do									\
    {									\
      _gcpro1.next = _tlgc_stack; _gcpro1.v = &V; _gcpro1.n = 1;	\
      ASGN_SPROT (V);							\
      _tlgc_stack = &_gcpro1;						\
    } while (0)

#define GCDECL2 struct tlgcs _gcpro1, _gcpro2
#define GCPRO2(V1, V2)  \
  do									\
    {									\
      _gcpro1.next = _tlgc_stack; _gcpro1.v = &V1; _gcpro1.n = 1;	\
      _gcpro2.next = &_gcpro1; _gcpro2.v = &V2; _gcpro2.n = 1;		\
      ASGN_SPROT (V1);							\
      ASGN_SPROT (V2);							\
      _tlgc_stack = &_gcpro2;						\
    } while (0)

#define GCDECL3 struct tlgcs _gcpro1, _gcpro2, _gcpro3
#define GCPRO3(V1, V2, V3)  \
  do									\
    {									\
      _gcpro1.next = _tlgc_stack; _gcpro1.v = &V1; _gcpro1.n = 1;	\
      _gcpro2.next = &_gcpro1; _gcpro2.v = &V2; _gcpro2.n = 1;		\
      _gcpro3.next = &_gcpro2; _gcpro3.v = &V3; _gcpro3.n = 1;		\
      ASGN_SPROT (V1);							\
      ASGN_SPROT (V2);							\
      ASGN_SPROT (V3);							\
      _tlgc_stack = &_gcpro3;						\
    } while (0)

#define GCDECL4 struct tlgcs _gcpro1, _gcpro2, _gcpro3, _gcpro4
#define GCPRO4(V1, V2, V3, V4)  \
  do									\
    {									\
      _gcpro1.next = _tlgc_stack; _gcpro1.v = &V1; _gcpro1.n = 1;	\
      _gcpro2.next = &_gcpro1; _gcpro2.v = &V2; _gcpro2.n = 1;		\
      _gcpro3.next = &_gcpro2; _gcpro3.v = &V3; _gcpro3.n = 1;		\
      _gcpro4.next = &_gcpro3; _gcpro4.v = &V4; _gcpro4.n = 1;		\
      ASGN_SPROT (V1);							\
      ASGN_SPROT (V2);							\
      ASGN_SPROT (V3);							\
      ASGN_SPROT (V4);							\
      _tlgc_stack = &_gcpro4;						\
    } while (0)

#define GCDECL5 struct tlgcs _gcpro1, _gcpro2, _gcpro3, _gcpro4, _gcpro5
#define GCPRO5(V1, V2, V3, V4, V5)  \
  do									\
    {									\
      _gcpro1.next = _tlgc_stack; _gcpro1.v = &V1; _gcpro1.n = 1;	\
      _gcpro2.next = &_gcpro1; _gcpro2.v = &V2; _gcpro2.n = 1;		\
      _gcpro3.next = &_gcpro2; _gcpro3.v = &V3; _gcpro3.n = 1;		\
      _gcpro4.next = &_gcpro3; _gcpro4.v = &V4; _gcpro4.n = 1;		\
      _gcpro5.next = &_gcpro4; _gcpro5.v = &V5; _gcpro5.n = 1;		\
      ASGN_SPROT (V1);							\
      ASGN_SPROT (V2);							\
      ASGN_SPROT (V3);							\
      ASGN_SPROT (V4);							\
      ASGN_SPROT (V5);							\
      _tlgc_stack = &_gcpro5;						\
    } while (0)

/* Restore the gc protection stack to its value upon entry.  */
#define GCUNPRO  (_tlgc_stack = _gcpro1.next)
