/* Interface to TLFILEStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLFILEStream.h,v 1.1 1998/01/08 16:13:14 tiggr Exp $  */

#import "TLStream.h"
#import "TLCons.h"
#import <stdio.h>

@interface TLFILEStream: TLObject <TLStream, TLMutableStream>
{
  FILE *f;
}

+(id <TLStream, TLInputStream>) streamWithFILE: (FILE *) an_f;
+(id <TLStream, TLMutableStream>) mutableStreamWithFILE: (FILE *) an_f;

+(id <TLStream, TLInputStream>) streamWithFileNamed: (id <TLString>) name;
+(id <TLStream, TLMutableStream>) mutableStreamWithFileNamed:
							(id <TLString>) name;

+(id <TLStream>) streamWithFileNamed: (id <TLString>) name
 alongPath: (TLCons *) path;

-initWithFILE: (FILE *) an_f;

@end
