/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTSelArgTypes.m,v 1.7 1998/01/05 00:58:13 tiggr Exp $  */

#define LTTSELECTOR_DECLARE_PRIVATE_METHODS
#import "LTTSelArgTypes.h"
#import "ltt.h"

/* A dictionary from string to arg types.  */
static TLDictionary *arg_types;

@implementation LTTSelArgTypes

+(LTTSelArgTypes *) argumentTypesWithString: (id <TLString>) a
{
  LTTSelArgTypes *s = [arg_types objectForKey: a];

  if (!s)
    {
      s = [[self gcAlloc] initWithArgs: a];
      [arg_types setObject: s forKey: a];
    }

  return s;
} /* +argumentTypesWithString: */

+(id <TLEnumerator>) argumentTypes
{
  return [arg_types valueEnumerator];
} /* +argumentTypes */

+initialize
{
  if (!arg_types)
    {
      arg_types = [TLDictionary dictionary];
      [arg_types gcLock];
    }

  return self;
} /* +initialize */

-(void) gcReference
{
  MARK (args);

  [super gcReference];
} /* -gcReference */

-(id) initWithArgs: (id <TLString>) a
{
  if (![super init])
    return nil;

  args = a;

  return self;
} /* -initWithArgs: */

-(id <TLString>) outputDefinitionName
{
  if (ltt_current_unit)
    return (id) formac (nil, @"%@%@_%@", TO_ATD_PREFIX,
			[ltt_current_unit outputName], args);
  else
    return (id) formac (nil, @"%@%@", TO_ATD_PREFIX, args);
}

-(void) print: (id) s quoted: (BOOL) ynp
{
  [(id) args print: s quoted: ynp];
} /* -print:quoted: */

@end
