/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTMeta.h,v 1.20 1998/01/05 00:58:07 tiggr Exp $  */

#import "LTTEntity.h"

@class LTTClass, LTTExtension, LTTInstance, LTTUnit;

@interface LTTMeta: LTTEntity
{
  /* Our unit.  */
  LTTUnit *unit;

  /* Our class.  */
  LTTClass *class;

  /* The main extension.  */
  LTTExtension *main;

  /* Other extensions, keyed on their name.  */
  TLDictionary *extensions;

  /* _All_ extensions, in a vector.  */
  TLVector *all_extensions;

  /* State supers.  */
  TLVector *state_supers;

  /* State direct subs.  */
  TLVector *state_subs;

  /* Behavioural supers.  */
  TLVector *behaviour_supers;

  /* Behavioural direct subs.  */
  TLVector *behaviour_subs;

  /* Our direct poser.  If more than one class poses us, still only one
     poses us directly, and the other ones pose our first poser.  */
  LTTMeta *poser;

  /* The class we pose.  If we ever want to pose more than one class, this
     must become a vector.  */
  LTTMeta *posed;

  /* Mark when searching.  */
  int mark;
}

+(LTTInstance *) instanceAndClassWithName: (id <TLString>) n
				     unit: (LTTUnit *) u;

+(id <TLEnumerator>) metas;

+(int) numMetas;

-(id) initWithName: (TLString *) n unit: (LTTUnit *) u;

-(LTTClass *) itsClass;
-(BOOL) classp;
-(void) setClass: (LTTClass *) c;

/* Return the extension with the name N.  If !N, the main extension is
   returned.  */
-(LTTExtension *) extensionNamed: (TLString *) n;

-(void) addExtension: (LTTExtension *) e;

/* Return an enumerator on _all_ extensions (thus including the main
   extension).  */
-(TLVector *) extensions;

/* Issue an error, since metas do not have instances (only a class has).  */
-(LTTInstance *) instance;

-(id <TLString>) outputSuperReference: (LTTMeta *) m;
-(id <TLString>) outputTypeName;

-(id <TLString>) qualifiedExternalName;

-(id <TLString>) extensionsDescriptionName;

-(id <TLString>) definitionName;
-(id <TLString>) referenceName;

-(id <TLString>) metaDefinitionName;
-(id <TLString>) metaReferenceName;
-(id <TLString>) metaTypeName;

-(LTTUnit *) unit;

-(void) addBehaviourSub: (LTTMeta *) m;
-(void) addBehaviourSuper: (LTTMeta *) m;

-(void) addStateSub: (LTTMeta *) m;
-(void) addStateSuper: (LTTMeta *) m;

-(TLVector *) stateSupers;
-(TLVector *) stateSubs;

-(int) numBehaviourSubs;
-(TLVector *) behaviourSubs;
-(int) numBehaviourSupers;
-(TLVector *) behaviourSupers;

-(int) numStateSubs;
-(int) numStateSupers;

/* Return ourselves, or, if we have a POSER, our poser's posedSelf.  */
-(LTTMeta *) posedSelf;

/* Return our poser, but not the META.  */
-(LTTMeta *) posedSelfNot: (LTTMeta *) m;

/* Return our poser, i.e. nil if we don't have one.  */
-(LTTMeta *) poser;

/* Return our posed, i.e. nil if we don't have one.  */
-(LTTMeta *) posed;

/* Set our poser to be P.  Actually, if we already have one, we pass this on
   to him.  */
-(void) setPoser: (LTTMeta *) p;

/* Set our posed to be P.  */
-(void) setPosed: (LTTMeta *) p;

/* Return whether M is a direct submeta, in some way peculiar to the
   method, of the receiving meta.  */
-(BOOL) isDirectSub: (LTTMeta *) m;
-(BOOL) isDirectBehaviourSub: (LTTMeta *) m;
-(BOOL) isDirectStateSub: (LTTMeta *) m;

/* Return whether M is a proper (transitive) submeta, in some way peculiar
   to the method, of the receiving meta.  */
-(BOOL) isProperSub: (LTTMeta *) m;
-(BOOL) isProperBehaviourSub: (LTTMeta *) m;
-(BOOL) isProperStateSub: (LTTMeta *) m;

#ifdef NOTYET
/* Return whether the receiving meta has M as a supermeta.  */
-(BOOL) hasProperSuper: (LTTMeta *) m;
-(BOOL) hasProperStateSuper: (LTTMeta *) m;
-(BOOL) hasProperBehaviourSuper: (LTTMeta *) m;
#endif

/* Given the proper super M, return the list of direct supers causing the
   inheritance of M by the receiving super.  */
-(TLCons *) directSuperForProperSuper: (LTTMeta *) m;

#ifdef LTTMETA_DECLARE_PRIVATE_METHODS

+(id) metaWithName: (id <TLString>) n unit: (LTTUnit *) u;

-(BOOL) isProperSub: (LTTMeta *) m mark: (int) k;
-(BOOL) isProperBehaviourSub: (LTTMeta *) m mark: (int) k;
-(BOOL) isProperStateSub: (LTTMeta *) m mark: (int) k;

#endif

@end

@interface LTTMeta (Semantics)

+(id) semanticsForInstance: (LTTInstance *) inst;

+(id) semanticsForClass: (LTTClass *) cls;

@end
