$Id: README.emacs,v 1.3 1997/08/03 12:16:16 tiggr Exp $

A major mode for editing TOM source in GNU Emacs does not yet exist.
For the moment, I use objc-mode, aided by the following in my .emacs:

;; TOM source automatically selects objc-mode.
(setq auto-mode-alist (cons '("\\.t$" . objc-mode) auto-mode-alist))

(defun tom-fill-doc (arg)
  "Iff within <doc> ... </doc>, fill the (TOM) doc.  Otherwise, invoke
fill-paragraph."
  (interactive "P")
    (let* ((current (point)) min (max (1- current))
           (old-fill-prefix fill-prefix))
      (if (save-excursion
            (and (let ((i (re-search-backward "<doc>" (point-min) t)))
                   (setq min (point)) i)
                 (let ((i (search-forward "</doc>" (point-max) t)))
                   (setq max (point)) i))
            (>= max current))
          (save-excursion
            (goto-char min)
            (beginning-of-line)
            (setq fill-prefix (concat (buffer-substring (point) min) "    "))
            (fill-region (point) (1+ max) arg)
            (setq fill-prefix old-fill-prefix))
        (fill-paragraph arg))))

(global-set-key "\M-q" 'tom-fill-doc)

--Tiggr <tiggr@ics.ele.tue.nl>
