#!/bin/sh
#
# To INSTALL SmallEiffel on UNIX like platforms (including LINUX).
#
# If you have the gcc compiler, simply run this script.
#
sed=${SmallEiffel:=1}
if [ ${sed} = 1 ];  then 
   echo Please set the environment Variable \'SmallEiffel\' with
   echo the absolute path of file SmallEiffel/sys/system.se
   exit 1
fi
if [ -d ${SmallEiffel} ]; then 
   echo Since release -0.79 the value of the environment
   echo variable SmallEiffel should be the absolute path of
   echo file SmallEiffel/sys/system.se
   echo Trying to fix this automatically.
   SmallEiffel=${SmallEiffel}/sys/system.se
fi
if [ ! -f ${SmallEiffel} ]; then
   echo File ${SmallEiffel} not found.
   echo Please check the value of the environment Variable
   echo \'SmallEiffel\' wich must be the absolute path of 
   echo the file SmallEiffel/sys/system.se
   exit 1
fi
SE=`dirname $SmallEiffel`
SE=`dirname $SE`
if [ -f ${SE} ]; then
   echo ${SE} "not found."
   exit 1
fi
cd ${SE}
cd bin_c
for fmake in *.make 
do
	chmod a+x ${fmake}
	echo Running ${fmake} ...
	./${fmake}
	cmd=`basename $fmake .make`
	if [ -x ../bin/${cmd} ]; then
		mv -f ../bin/${cmd} ../bin/${cmd}.old
        fi
	mv -f ${cmd} ../bin/${cmd}
	/bin/rm -f ../bin/${cmd}.old
done
/bin/rm -f *.o
echo Setting system name.
/bin/rm -f ${SE}/sys/system.se
echo "UNIX" > ${SE}/sys/system.se
echo Writing default ${SE}/sys/loadpath.UNIX
if [ Z`echo '\c'` = Z ]
 then
	echoopt=''
	echosuf='\c'
 else
 	echoopt='-n'
 	echosuf=''
fi
/bin/rm -f ${SE}/sys/loadpath.UNIX
echo    "./"               > ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_std/"  >> ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_rand/" >> ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_show/" >> ${SE}/sys/loadpath.UNIX
echo $echoopt "${SE}/lib_se/$echosuf" >> ${SE}/sys/loadpath.UNIX
echo Garbage Collector selection :
${SE}/misc/GC.SH
echo Done.
