--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class E_PRECURSOR_PROCEDURE
   --
   -- Handling of the pseudo variable "Current".
   --

inherit
   E_PRECURSOR
      redefine run_feature
      end;
   INSTRUCTION;

creation make

feature {E_PRECURSOR}

   run_feature: RUN_FEATURE_10;

feature

   end_mark_comment: BOOLEAN is false;

   is_pre_computable: BOOLEAN is false;

feature

   collect_c_tmp is
      do
         if arguments /= Void then
            arguments.collect_c_tmp;
         end;
      end;

   to_runnable(ct: TYPE): like Current is
      local
         wrf: RUN_FEATURE;
         super: EFFECTIVE_ROUTINE;
         pn: PRECURSOR_NAME;
      do
         if current_type = Void then
            current_type := ct;
            Result := Current;
            wrf := small_eiffel.top_rf;
            if wrf.result_type /= Void then
               eh.add_position(start_position);
               fatal_error("Inside a function, a Precursor call must %
                           %be a function call (not a procedure call).");
            end;
            super := super_feature(wrf);
            pn := precursor_name(wrf.name,super)
            !!run_feature.make(ct,pn,super);
            prepare_arguments(ct);
         else
            !!Result.make(start_position,parent,arguments);
            Result := Result.to_runnable(ct);
         end;
      end;

feature {NONE}

   put_semi_colon is
      do
         if fmt.semi_colon_flag then
            fmt.put_character(';');
         end;
      end;

end -- E_PRECURSOR_PROCEDURE
