#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/repl/loadmodule.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  repl
 |
 `------------------------------------------------------------------------|#

(define (module-name-components->rel-paths (lst <list>))
  (let ((d (make <directory-name>
		 rooted-at: #f
		 steps: lst))
	(d2 (make <directory-name>
		  rooted-at: #f
		  steps: (reverse! (cdr (reverse lst))))))
    (list (cons (make <file-name>
		      file-directory: d
		      filename: "module"
		      extension: "mif")
		'mif)
	  (cons (make <file-name>
		      file-directory: d
		      filename: "module"
		      extension: "scm")
		'scm)
	  (cons (make <file-name>
		      file-directory: d2
		      extension: "mif"
		      filename: (last lst))
		'mif))))

(define (module-name->rel-paths (name <symbol>))
  (let ((lst (string-split (symbol->string name) #\.)))
    ;; only consider module names with at least one `.' and
    ;; with no empty components
    (if (and (> (length lst) 1)
	     (every? (lambda ((p <string>))
		       (not (eq? (string-length p) 0)))
		     lst))
	(module-name-components->rel-paths lst)
	#f)))

(define (find-m-by-style (search <list>) (in <directory-name>))
  (let loop ((s search))
    (if (null? s)
	(values)
	(let* ((p (append-path in (caar s)))
	       (f (pathname->os-path p)))
	  (if (os-file-exists? f)
	      (values f p (cdar s))
	      (loop (cdr s)))))))

(define (hier-find-module name)
  (let ((rels (module-name->rel-paths name)))
    (if rels
	(let loop ((p (module-search-path)))
	  (if (null? p)
	      #f
	      (bind ((sfn fn typ (find-m-by-style rels (car p))))
		(if sfn
		    (values fn typ)
		    (loop (cdr p))))))
	#f)))

(define (load-module-from-source (name <symbol>) (f <file-name>))
  (let* ((e (make-user-initial))
	 (n (load-into e (pathname->os-path f)))
	 (ln  (if (symbol? n) n name))
	 (b (get-loaded-module ln)))
    (or b
	(error "~a: did not define-module ~s" f ln))))

;;; load a module using the foo.bar.baz ==> foo/bar/baz
;;; filesystem naming convention

(define (load-hier-module (name <symbol>))
  (bind ((fn typ (hier-find-module name)))
    (if fn
	(case typ
	  ((mif) (link-load-module name fn))
	  ((scm) (load-module-from-source name fn)))
	#f)))

(%early-once-only
 (add-module-finder! load-hier-module))
