#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/threadv.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1998.06.13 09:45:28
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  corelib
 |
 `------------------------------------------------------------------------|#

;;;
;;;  the intended use of the direct thread variables
;;;  is for:
;;;    direct: 1 => *input-port*
;;;    direct: 2 => *output-port*
;;;    direct: 3 => *hander-chain*
;;;

(define *thread-var-prototype* '#(#f #f #f #f))
(define *direct-names* '#(*input-port* *output-port* *handler-chain*))
(define *thread-var-init-values* #f)

(define (thread-var-default-state)
  (clone *thread-var-prototype*))

(define (add-thread-var! name init)
  (set! *thread-var-init-values*
	(make-gvec <vector> 
		   name
		   init
		   *thread-var-init-values*)))

(define (set-direct-thread-init! index init)
  (vector-set! *thread-var-prototype* index init))

;;;

(define-syntax (direct-thread-var-ref index)
  (gvec-ref (get-thread-state-reg) index))

(define (indirect-thread-var-ref name)
  (let loop ((p (gvec-ref (get-thread-state-reg) 0)))
    (if p
	(if (eq? (gvec-ref p 0) name)
	    (gvec-ref p 1)
	    (loop (gvec-ref p 2)))
	(loop *thread-var-init-values*))))

(define (indirect-thread-var-set! name val)
  (let loop ((p (gvec-ref (get-thread-state-reg) 0)))
    (if p
	(if (eq? (gvec-ref p 0) name)
	    (let ((o (gvec-ref p 1)))
	      (gvec-set! p 1 val)
	      o)
	    (loop (gvec-ref p 2)))
	; this shouldn't loop forever, because we are only
	; called by a macro which ensures that the name we're
	; looking for is on the list somewhere
	(loop *thread-var-init-values*))))

;;;

(define-macro define-thread-var 
  (macro-rules ()
   ((_ name)
    `(define-thread-var ,name #f))
   ;
   ((_ name init direct: k)
    `(begin
       ; direct vars are immutable, but they can be init'ed
       (%early-once-only
	(set-direct-thread-init! ,k ,init))
       (define-syntax ,name
	 (else
	  (direct-thread-var-ref ,k)))))
   ;
   ((_ name init :indirect)
    `(begin
       (%early-once-only (add-thread-var! ',name ,init))
       (define-syntax ,name
	 (setter-form (val)
	  (indirect-thread-var-set! ',name val))
	 (else
	  (indirect-thread-var-ref ',name)))))
   ;
   ((_ name init)
    (let* ((direct-spot (memq name '(*input-port*
				     *output-port*
				     *handler-chain*))))
      (if direct-spot
	  `(define-thread-var ,name ,init
	     direct: ,(- 4 (length direct-spot)))
	  `(define-thread-var ,name ,init :indirect))))))
   
;;;

(define-macro (thread-let bdgs . body)
  (if (null? bdgs)
      `(let () ,@body)
      (let ((n-save (gensym))
	    (n (gensym)))
	(define (make-new-thread-state bdgs saved-ts)
	  `(make-gvec 
	    <vector>
	    ,(accum-indir-changes bdgs saved-ts)
	    ,@(map (lambda (i)
		     (let ((b (assq (vector-ref '#(*input-port*
						   *output-port*
						   *handler-chain*)
						i)
				    bdgs)))
		       (if b
			   (cadr b)
			   `(gvec-ref ,saved-ts ,(+ i 1)))))
		   (range 3))))
	(define (accum-indir-changes bdgs saved-ts)
	  (if (null? bdgs)
	      `(gvec-ref ,saved-ts 0)
	      (if (memq (caar bdgs) '(*input-port* 
				      *output-port*
				      *handler-chain*))
		  (accum-indir-changes (cdr bdgs) saved-ts)
		  `(make-gvec <vector>
			      ',(caar bdgs)
			      ,(cadar bdgs)
			      ,(accum-indir-changes (cdr bdgs) saved-ts)))))
	;
	`(dynamic-call-thunk
	  #f
	  #f
	  (lambda () ,@body)
	  (get-dynamic-state-reg)
	  (let ((,n-save (get-thread-state-reg)))
	    ,(make-new-thread-state bdgs n-save))))))
