(define-module graphics.geometry (unquote)
  (unquote
   (import usual-inlines)
   (load "geom.scm")
   (export rect->values point->values size->values
	   point->size size->point)
   ;
   (load "bezier.scm")
   (export clear-coefficient-cache!)
   ;
   (load "vecmath.scm")
   ;
   (import sort) ; huge overkill
   (load "clip.scm")
   ;
   (load "transforms.scm")
   (export translate scale rotate
	   make-affine-transform transform <transform> 
	   concatenate-transform $identity-transform
	   invert-transform
	   matrix)
   ;
   (import tables)
   (load "geometry-table.scm")
   (export make-geometry-table <geometry-table>)
   ;
   (export <point> x y $zero-point)
   (export <line> from to)
   (export <size> width height dx dy $zero-size)
   (export make-point make-line make-size)
   (export point+ point- size- size+ size* normalize inner-product)
   ;
   (export <rect>
	   origin size 
	   origin-x origin-y size-width size-height $zero-rect
	   ;; rectangle constructors
	   make-rect make-rect2 bbox-rect)
   ;
   (export limit-x limit-y center-x center-y point-in-rect? inset-rect)
   (export lower-left upper-right lower-right upper-left)
   (export offset-point offset-rect)
   (export intersect-rect union-rect)

   (export clip-to-rect inside-rect? rects-intersect? clip-to-segment 
	   find-perp line-intersect)
   (export line-vector point-on distance^2 distance
	   intersection-parameter)
   (export <bezier-curve> curv subdivide
	   start-point first-handle second-handle end-point
	   set-start-point! set-first-handle! 
	   set-second-handle! set-end-point!)
   ;
   (load "persist.scm")
   (export *geometry-classes*)
   ;
   ; methods for standard math operators
   ;
   (load "stdmath.scm")))

