(define-module graphics.color ()
  (&module
   (import usual-inlines)
   (import regex)  ; for parsing color strings
   (import tables) ; for color hash tables
   ;;
   (load "color.scm")
   (load "table.scm")
   ;; public
   (export <color>
	   color?
	   $white
	   $black
	   make-color
	   color-red
	   color-green
	   color-blue
	   color-rgb            ;; 3 float values
	   color-rgb-components ;; 3 16-bit values
	   color=?
	   color->hash
	   make-color-table)
   ;; internal
   (export red-component
	   green-component
	   blue-component)
   ;;
   (load "dither.scm")
   (export compute-dithering)
   ;;
   (load "pixel.scm")
   ;; public
   (export <pixel>
	   $clear
	   make-pixel
	   pixel-alpha)
   ;; internal
   (export alpha-component
	   pixel-rgba)
   ;;
   (load "parse.scm")
   (export string->color)
   ;;
   (load "math.scm")
   (export color*        ;; <color> * <real>
	   color+        ;; <color> + <color>
	   pixel+)
   ))

