
(define-class <color> (<object>)
  ;; the components are expressed in 0..65535
  (red-component type: <fixnum> :sealed)
  (green-component type: <fixnum> :sealed)
  (blue-component type: <fixnum> :sealed))

(define-method color-red ((self <color>))
  (/ (red-component self) 65535.0))

(define-method color-green ((self <color>))
  (/ (green-component self) 65535.0))

(define-method color-blue ((self <color>))
  (/ (blue-component self) 65535.0))

(define (color? x)
  (instance? x <color>))


(define (color-comp r)
  (min 65535 (max 0 (inexact->exact (truncate (* r 65536))))))

(define-macro color
  (macro-rules ()
    ((_ #key red green blue)
     (if (and (real? red) (>= red 0) (<= red 1)
              (real? green) (>= green 0) (<= green 1)
              (real? blue) (>= blue 0) (<= blue 1))
         (list 'quote
               (make <color>
                     red-component: (color-comp red)
                     green-component: (color-comp green)
                     blue-component: (color-comp blue)))
         (error "color: 0-1-valued constants required")))
    ((_ #key gray)
     (if (and (real? gray) (>= gray 0) (<= gray 1))
         (list 'quote
               (make <color>
                     red-component: (color-comp gray)
                     green-component: (color-comp gray)
                     blue-component: (color-comp gray)))
         (error "color: 0-1-valued constant required" gray)))))

(define $white (color gray: 1))
(define $black (color gray: 0))

(define (mkcolor r g b) ; r,g,b in X coords ie, 0-65535
  (cond
   ((and (= r 0) (= g 0) (= b 0)) $black)
   ((and (= r 65535) (= g 65535) (= b 65535)) $white)
   (else
    (make <color>
	  red-component: r
	  green-component: g
	  blue-component: b))))

(define (make-color #key (red type: <real> default: 1) 
                         (green type: <real> default: 1) 
                         (blue type: <real> default: 1))
  (mkcolor (color-comp red)
	   (color-comp green)
	   (color-comp blue)))

(define-method color-rgb-components ((self <color>))
  (values (red-component self)
          (green-component self)
          (blue-component self)))

(define-method color-rgb ((self <color>))
  (values (/ (red-component self) 65535.0)
          (/ (green-component self) 65535.0)
          (/ (blue-component self) 65535.0)))
