/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.TableUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.table.JTableHeader;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.text.Keymap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;

public class BasicTableUI
extends TableUI
implements MouseListener,
MouseMotionListener,
FocusListener,
Serializable {
    protected JTable table;
    private boolean phantomMousePressed = false;
    private KeyListener tableKeyListener;
    protected transient Component dispatchComponent;
    protected CellRendererPane rendererPane;

    private void registerArrowKey(int n, int n2, int n3) {
        this.table.registerKeyboardAction(new ArrowKeyAction(n2, n3), KeyStroke.getKeyStroke(n, 0), 0);
    }

    private void registerKeyboardActions() {
        this.registerArrowKey(39, 1, 0);
        this.registerArrowKey(37, -1, 0);
        this.registerArrowKey(38, 0, -1);
        this.registerArrowKey(40, 0, 1);
        this.tableKeyListener = new TableKeyListener();
        this.table.addKeyListener(this.tableKeyListener);
    }

    private void unregisterKeyboardActions() {
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.table.removeKeyListener(this.tableKeyListener);
    }

    private void moveAnchor(int n, int n2) {
        boolean bl;
        TableCellEditor tableCellEditor;
        if (this.table.isEditing() && (tableCellEditor = this.table.getCellEditor()) != null && !(bl = tableCellEditor.stopCellEditing())) {
            return;
        }
        this.updateSelection(n, n2, false, true);
    }

    private void dispatchKeyboardEvent(KeyEvent keyEvent) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n != -1 && n2 != -1 && !this.table.isEditing()) {
            boolean bl = this.table.editCellAt(n, n2);
            this.table.requestFocus();
            if (!bl) {
                return;
            }
        }
        Component component = this.table.getEditorComponent();
        if (this.table.isEditing() && component != null) {
            char c = keyEvent.getKeyChar();
            if (component instanceof JTextField) {
                KeyStroke keyStroke;
                JTextField jTextField = (JTextField)component;
                Keymap keymap = jTextField.getKeymap();
                Action action = keymap.getAction(keyStroke = KeyStroke.getKeyStroke((int)c, 0));
                if (action == null) {
                    action = keymap.getDefaultAction();
                }
                if (action != null) {
                    ActionEvent actionEvent = new ActionEvent(jTextField, 1001, String.valueOf(c));
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    private void configureTable() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        jComponent.addFocusListener(this);
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.configureTable();
        this.registerKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.table.remove(this.rendererPane);
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this);
        jComponent.removeFocusListener(this);
        this.unregisterKeyboardActions();
        this.rendererPane = null;
        this.table = null;
    }

    private void repaintAnchorCell() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        this.table.repaint(rectangle);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.table.getSelectedColumn() == -1) {
            this.table.setColumnSelectionInterval(0, 0);
        }
        if (this.table.getSelectedRow() == -1) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.repaintAnchorCell();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaintAnchorCell();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dispatchComponent != null) {
            this.dispatchComponent = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.dispatchComponent != null) {
            this.dispatchComponent = null;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.dispatchComponent != null) {
            this.dispatchComponent = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.phantomMousePressed) {
            return;
        }
        this.phantomMousePressed = true;
        Point point = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.columnAtPoint(point);
        if (n2 == -1 || n == -1) {
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (rectangle.contains(point)) {
            this.table.editCellAt(n, n2, mouseEvent);
        }
        if (!this.table.isEditing()) {
            boolean bl;
            this.table.requestFocus();
            boolean bl2 = mouseEvent.isControlDown();
            boolean bl3 = mouseEvent.isShiftDown();
            boolean bl4 = bl = bl2 && this.table.isCellSelected(n, n2);
            if (!bl2 && !bl3) {
                this.clearSelection();
            }
            this.updateSelection(n, n2, bl, !bl3 || bl);
            return;
        }
        Component component = this.table.getEditorComponent();
        Point point2 = SwingUtilities.convertPoint(this.table, new Point(mouseEvent.getX(), mouseEvent.getY()), component);
        this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        this.dispatchComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.dispatchComponent));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.table.isEditing()) {
            if (this.dispatchComponent != null) {
                this.dispatchComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.dispatchComponent));
            }
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.columnAtPoint(point);
        if (n2 == -1 || n == -1) {
            return;
        }
        this.updateSelection(n, n2, false, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.phantomMousePressed = false;
        if (this.table.isEditing()) {
            if (this.dispatchComponent != null) {
                this.dispatchComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.dispatchComponent));
            }
            this.dispatchComponent = null;
            return;
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        Rectangle rectangle = graphics.getClipBounds();
        jTable.getSize();
        if (jTable.getColumnModel() == null) {
            return;
        }
        Dimension dimension = this.getPreferredSize(jTable);
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        rectangle2 = rectangle2.intersection(rectangle);
        graphics.setColor(jTable.getParent().getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (rectangle2.height < 0 || rectangle2.width < 0) {
            return;
        }
        Color color = jTable.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        this.drawGridInClipRect(rectangle2, graphics);
        Rectangle rectangle3 = graphics.getClipBounds();
        int n = jTable.rowAtPoint(new Point(0, rectangle3.y));
        int n2 = this.lastVisibleRow(rectangle3);
        Rectangle rectangle4 = new Rectangle(0, 0, jTable.getColumnModel().getTotalColumnWidth(), jTable.getRowHeight() + jTable.getIntercellSpacing().height);
        rectangle4.y = n * rectangle4.height;
        int n3 = n;
        while (n3 <= n2) {
            if (rectangle4.intersects(rectangle2)) {
                Rectangle rectangle5 = rectangle4.intersection(rectangle2);
                this.drawRowInClipRect(n3, rectangle5, graphics);
            }
            rectangle4.y += rectangle4.height;
            ++n3;
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        Dimension dimension = new Dimension();
        int n = jTable.getAutoResizeMode();
        Container container = jTable.getParent();
        if (n != 0 && container instanceof JViewport) {
            dimension.width = container.getBounds().width;
            jTable.sizeColumnsToFit(n == 1);
        } else {
            dimension.width = jTable.getColumnModel().getTotalColumnWidth();
        }
        dimension.height = jTable.getRowCount() * (jTable.getRowHeight() + jTable.getIntercellSpacing().height);
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private int lastVisibleRow(Rectangle rectangle) {
        int n = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle.height - 1));
        if (n == -1) {
            n = this.table.getRowCount() - 1;
        }
        return n;
    }

    protected void drawGridInClipRect(Rectangle rectangle, Graphics graphics) {
        graphics.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.drawHorizontalLinesInClipRect(rectangle, graphics);
        }
        if (this.table.getShowVerticalLines()) {
            this.drawVerticalLinesInClipRect(rectangle, graphics);
        }
    }

    protected void drawHorizontalLinesInClipRect(Rectangle rectangle, Graphics graphics) {
        int n = this.table.getRowHeight() + this.table.getIntercellSpacing().height;
        Rectangle rectangle2 = graphics.getClipBounds();
        int n2 = this.table.rowAtPoint(new Point(0, rectangle2.y));
        int n3 = this.lastVisibleRow(rectangle2);
        int n4 = n * n2 + (n - 1);
        int n5 = n2;
        while (n5 <= n3) {
            if (n4 >= rectangle.y && n4 <= rectangle.y + rectangle.height) {
                graphics.drawLine(rectangle.x, n4, rectangle.x + rectangle.width - 1, n4);
            }
            n4 += n;
            ++n5;
        }
    }

    protected void drawVerticalLinesInClipRect(Rectangle rectangle, Graphics graphics) {
        int n = 0;
        int n2 = this.table.getColumnCount();
        int n3 = 0;
        while (n3 <= n2) {
            if (n > 0 && n - 1 >= rectangle.x && n - 1 <= rectangle.x + rectangle.width) {
                graphics.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
            }
            if (n3 < n2) {
                n += this.table.getColumnModel().getColumn(n3).getWidth() + this.table.getIntercellSpacing().width;
            }
            ++n3;
        }
    }

    protected void drawRowInClipRect(int n, Rectangle rectangle, Graphics graphics) {
        Component component;
        TableCellRenderer tableCellRenderer;
        int n2 = 0;
        boolean bl = false;
        Rectangle rectangle2 = null;
        int n3 = -1;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        Dimension dimension = this.table.getIntercellSpacing();
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle3 = new Rectangle();
        rectangle3.height = this.table.getRowHeight() + dimension.height;
        rectangle3.y = n * rectangle3.height;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle3.width = tableColumn.getWidth() + dimension.width;
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (jTableHeader == null || tableColumn != jTableHeader.getDraggedColumn()) {
                    tableCellRenderer = this.getCellRenderer(n2);
                    component = this.prepareRenderer(tableCellRenderer, this.table, n, n2);
                    this.drawWithComponent(graphics, component, rectangle3);
                } else {
                    graphics.setColor(this.table.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n3 = n2;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n2;
        }
        if (n3 != -1 && rectangle2 != null && (tableCellRenderer = this.getCellRenderer(n3)) != null) {
            component = this.prepareRenderer(tableCellRenderer, this.table, n, n3);
            rectangle2.x += jTableHeader.getDraggedDistance();
            Color color = this.table.getBackground();
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            graphics.setColor(this.table.getGridColor());
            int n4 = rectangle2.x;
            int n5 = rectangle2.y;
            int n6 = n4 + rectangle2.width - 1;
            int n7 = n5 + rectangle2.height - 1;
            if (this.table.getShowVerticalLines()) {
                graphics.drawLine(n6, n5, n6, n7);
            }
            if (this.table.getShowHorizontalLines()) {
                graphics.drawLine(n4, n7, n6, n7);
            }
            this.drawWithComponent(graphics, component, rectangle2);
        }
    }

    protected TableCellRenderer getCellRenderer(int n) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            Class clazz = this.table.getColumnClass(n);
            tableCellRenderer = this.table.getDefaultRenderer(clazz);
        }
        return tableCellRenderer;
    }

    protected Component prepareRenderer(TableCellRenderer tableCellRenderer, JTable jTable, int n, int n2) {
        Object object = jTable.getValueAt(n, n2);
        boolean bl = jTable.isCellSelected(n, n2);
        boolean bl2 = jTable.getSelectedRow() == n;
        boolean bl3 = jTable.getSelectedColumn() == n2;
        boolean bl4 = bl2 && bl3 && jTable.hasFocus();
        return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl4, n, n2);
    }

    protected void drawWithComponent(Graphics graphics, Component component, Rectangle rectangle) {
        Dimension dimension = this.table.getIntercellSpacing();
        rectangle.setBounds(rectangle.x + dimension.width / 2, rectangle.y + dimension.height / 2, rectangle.width - dimension.width, rectangle.height - dimension.height);
        if (component.getParent() == null) {
            this.rendererPane.add(component);
        }
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        rectangle.setBounds(rectangle.x - dimension.width / 2, rectangle.y - dimension.height / 2, rectangle.width + dimension.width, rectangle.height + dimension.height);
    }

    private void updateSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (!bl) {
                listSelectionModel.addSelectionInterval(n, n);
            } else {
                listSelectionModel.removeSelectionInterval(n, n);
                return;
            }
        }
        listSelectionModel.setLeadSelectionIndex(n);
    }

    private void updateSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.table.scrollRectToVisible(rectangle);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.table.getColumnModel().getSelectionModel();
        this.updateSelectionModel(listSelectionModel2, n2, bl, bl2);
        this.updateSelectionModel(listSelectionModel, n, bl, bl2);
    }

    private void clearSelection() {
        this.clearSelection(this.table.getColumnModel().getSelectionModel());
        this.clearSelection(this.table.getSelectionModel());
    }

    private void clearSelection(ListSelectionModel listSelectionModel) {
        listSelectionModel.removeSelectionInterval(listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex());
    }

    private class ArrowKeyAction
    extends AbstractAction
    implements Serializable {
        protected transient int dx;
        protected transient int dy;

        public ArrowKeyAction(int n, int n2) {
            BasicTableUI.this = BasicTableUI.this;
            this.dx = n;
            this.dy = n2;
        }

        public boolean inRange(int n, int n2) {
            return n >= 0 && n < n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTableUI.this.table.getSelectedColumn() + this.dx;
            if (!this.inRange(n, BasicTableUI.this.table.getColumnCount())) {
                return;
            }
            int n2 = BasicTableUI.this.table.getSelectedRow() + this.dy;
            if (!this.inRange(n2, BasicTableUI.this.table.getRowCount())) {
                return;
            }
            if (this.dx != 0) {
                BasicTableUI.this.clearSelection(BasicTableUI.this.table.getColumnModel().getSelectionModel());
            }
            if (this.dy != 0) {
                BasicTableUI.this.clearSelection(BasicTableUI.this.table.getSelectionModel());
            }
            BasicTableUI.this.moveAnchor(n2, n);
        }
    }

    private class TableKeyListener
    implements KeyListener,
    Serializable {
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                default: {
                    BasicTableUI.this.dispatchKeyboardEvent(keyEvent);
                }
                case 16: 
                case 17: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        TableKeyListener() {
            BasicTableUI.this = BasicTableUI.this;
        }
    }
}

