/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.LabelUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicLabelUI
extends LabelUI
implements Serializable,
PropertyChangeListener {
    protected static BasicLabelUI labelUI = new BasicLabelUI();

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        graphics.setColor(jLabel.getForeground());
        BasicGraphicsUtils.drawString(graphics, string, n3, n, n2);
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonic();
        Color color = jLabel.getBackground();
        graphics.setColor(color.brighter());
        BasicGraphicsUtils.drawString(graphics, string, n3, n, n2);
        graphics.setColor(color.darker());
        BasicGraphicsUtils.drawString(graphics, string, n3, n + 1, n2 + 1);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(jComponent.getSize());
        Insets insets = jComponent.getInsets();
        rectangle3.x = insets.left;
        rectangle3.y = insets.top;
        rectangle3.width -= insets.left + insets.right;
        rectangle3.height -= insets.top + insets.bottom;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, rectangle3, rectangle, rectangle2);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
        if (string != null) {
            int n = rectangle2.x;
            int n2 = rectangle2.y + fontMetrics.getAscent();
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string2, n, n2);
                return;
            }
            this.paintDisabledText(jLabel, graphics, string2, n, n2);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon = jLabel.getIcon();
        Insets insets = jLabel.getInsets();
        Font font = jLabel.getFont();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (icon == null && (string == null || string != null && font == null)) {
            return new Dimension(n, n2);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + n, icon.getIconHeight() + n2);
        }
        FontMetrics fontMetrics = jLabel.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(n, n2, Short.MAX_VALUE, Short.MAX_VALUE);
        this.layoutCL(jLabel, fontMetrics, string, icon, rectangle3, rectangle, rectangle2);
        Dimension dimension = rectangle.union(rectangle2).getSize();
        dimension.width += n;
        dimension.height += n2;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "Label.background", "Label.foreground", "Label.font");
        this.installKeyboardActions(jComponent);
        jComponent.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions(jComponent);
        jComponent.removePropertyChangeListener(this);
    }

    protected void installKeyboardActions(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        int n = jLabel.getDisplayedMnemonic();
        Component component = jLabel.getLabelFor();
        jComponent.resetKeyboardActions();
        if (n != 0 && component != null) {
            jLabel.registerKeyboardAction(new PressAction(jLabel, component), KeyStroke.getKeyStroke(n, 8, false), 2);
        }
    }

    protected void uninstallKeyboardActions(JComponent jComponent) {
        jComponent.resetKeyboardActions();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return labelUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("labelFor") || propertyChangeEvent.getPropertyName().equals("displayedMnemonic")) {
            this.installKeyboardActions((JLabel)propertyChangeEvent.getSource());
        }
    }

    static class PressAction
    extends AbstractAction {
        JLabel owner;
        Component labelFor;

        PressAction(JLabel jLabel, Component component) {
            super("nothing");
            this.owner = jLabel;
            this.labelFor = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.owner.registerKeyboardAction(new ReleaseAction(this.owner, this.labelFor), KeyStroke.getKeyStroke(this.owner.getDisplayedMnemonic(), 8, true), 0);
            this.owner.registerKeyboardAction(new ReleaseAction(this.owner, this.labelFor), KeyStroke.getKeyStroke(0, 8, true), 0);
            this.owner.requestFocus();
        }

        public boolean isEnabled() {
            return this.owner.isEnabled();
        }
    }

    static class ReleaseAction
    extends AbstractAction {
        JLabel owner;
        Component labelFor;

        ReleaseAction(JLabel jLabel, Component component) {
            super("giveFocusToLabelFor");
            this.owner = jLabel;
            this.labelFor = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.owner.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.owner.getDisplayedMnemonic(), 8, true));
            this.owner.unregisterKeyboardAction(KeyStroke.getKeyStroke(0, 8, true));
            this.labelFor.requestFocus();
        }

        public boolean isEnabled() {
            return this.owner.isEnabled();
        }
    }
}

