/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.AncestorEvent;
import com.sun.java.swing.event.AncestorListener;
import com.sun.java.swing.plaf.OptionPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public abstract class AbstractOptionPaneUI
extends OptionPaneUI
implements Serializable {
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;

    public abstract Icon getIcon();

    public abstract Object getMessage();

    public abstract Object[] getButtons();

    public abstract Container getContainer();

    public abstract int getInitialIndex();

    protected Color getLabelColor() {
        return UIManager.getColor("OptionPane.foreground");
    }

    public boolean getSizeButtonsToSameWidth() {
        return false;
    }

    public boolean containsCustomComponents() {
        return this.hasCustomComponents;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public void selectInitialValue() {
        JRootPane jRootPane;
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
        if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
            jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
        }
    }

    protected void burstStringInto(Container container, String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        if (n2 > n) {
            int n3 = string.lastIndexOf(32, n);
            if (n3 <= 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 > 0 && n3 < n2) {
                this.burstStringInto(container, string.substring(0, n3), n);
                this.burstStringInto(container, string.substring(n3 + 1), n);
                return;
            }
        }
        container.add(new JLabel(string, 2));
    }

    protected void appendDescription(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
                return;
            }
        } else {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = 0;
                while (n2 < objectArray.length) {
                    this.appendDescription(container, gridBagConstraints, objectArray[n2], n, false);
                    ++n2;
                }
                return;
            }
            if (object instanceof Icon) {
                JLabel jLabel = new JLabel((Icon)object, n);
                jLabel.setForeground(this.getLabelColor());
                this.appendDescription(container, gridBagConstraints, jLabel, n, true);
                return;
            }
            String string = object.toString();
            int n3 = string.length();
            if (n3 <= 0) {
                return;
            }
            int n4 = string.indexOf(10);
            if (n4 >= 0) {
                if (n4 == 0) {
                    this.appendDescription(container, gridBagConstraints, new 1(), n, true);
                } else {
                    this.appendDescription(container, gridBagConstraints, string.substring(0, n4), n, false);
                }
                this.appendDescription(container, gridBagConstraints, string.substring(n4 + 1), n, false);
                return;
            }
            if (n3 > n) {
                Box box = Box.createVerticalBox();
                this.burstStringInto(box, string, n);
                this.appendDescription(container, gridBagConstraints, box, n, true);
                return;
            }
            JLabel jLabel = new JLabel(string, 2);
            jLabel.setForeground(this.getLabelColor());
            this.appendDescription(container, gridBagConstraints, jLabel, n, true);
        }
    }

    protected void appendButtons(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            Object object;
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            int n4 = 0;
            while (n4 < n2) {
                JButton jButton;
                Component component;
                object = objectArray[n4];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString());
                    container.add(jButton);
                    int n5 = n4;
                    jButton.addActionListener(new 2(n5, this));
                    component = jButton;
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[n4] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (n4 == n) {
                    this.initialFocusComponent = component;
                    if (this.initialFocusComponent instanceof JButton) {
                        jButton = (JButton)this.initialFocusComponent;
                        jButton.addAncestorListener(new 3());
                    }
                }
                ++n4;
            }
            ((SyncingLayoutManager)container.getLayout()).setSyncsAll(bl && bl2);
            if (bl && bl2) {
                int n6 = n2 <= 2 ? 8 : 4;
                int n7 = 0;
                while (n7 < n2) {
                    object = jButtonArray[n7];
                    ((AbstractButton)object).setMargin(new Insets(2, n6, 2, n6));
                    ++n7;
                }
            }
        }
    }

    public void createdButtonFired(int n) {
    }

    protected void emptyContainer(Container container) {
        container.removeAll();
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "West");
        }
    }

    protected Container createBody() {
        4 var1_1 = new 4();
        var1_1.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        5 var3_3 = new 5();
        6 var4_4 = new 6();
        var4_4.setLayout(new BorderLayout());
        var4_4.add((Component)new 7(), "West");
        var4_4.add((Component)var3_3, "Center");
        var3_3.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.appendDescription(var3_3, gridBagConstraints, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        var1_1.add((Component)var4_4, "Center");
        this.addIcon(var1_1);
        return var1_1;
    }

    protected Insets getButtonInsets() {
        return new Insets(6, 0, 0, 0);
    }

    protected Insets getBodyInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected Container createButtons() {
        8 var1_1 = new 8();
        var1_1.setLayout(new SyncingLayoutManager(true, 6));
        this.appendButtons(var1_1, this.getButtons(), this.getInitialIndex());
        return var1_1;
    }

    protected void validateComponent() {
        Container container = this.getContainer();
        this.hasCustomComponents = false;
        this.initialFocusComponent = null;
        if (container != null) {
            this.emptyContainer(container);
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.createBody());
            container.add(this.createButtons());
        }
    }

    private final class 1
    extends Component {
        public Dimension getPreferredSize() {
            Font font = this.getFont();
            if (font != null) {
                return new Dimension(1, font.getSize() + 2);
            }
            return new Dimension(0, 0);
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements ActionListener {
        private final /* synthetic */ AbstractOptionPaneUI this$0;
        private final /* synthetic */ int val$buttonIndex;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.createdButtonFired(this.val$buttonIndex);
        }

        /* synthetic */ 2(int n, AbstractOptionPaneUI abstractOptionPaneUI) {
            this.val$buttonIndex = n;
            this.this$0 = abstractOptionPaneUI;
        }
    }

    private final class 3
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JButton jButton = (JButton)ancestorEvent.getComponent();
            JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
            if (jRootPane != null) {
                jRootPane.setDefaultButton(jButton);
            }
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends Container {
        public Insets getInsets() {
            return AbstractOptionPaneUI.this.getBodyInsets();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends Container {
        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends Container {
        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends Container {
        public Dimension getPreferredSize() {
            return new Dimension(15, 1);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends Container {
        public Insets getInsets() {
            return AbstractOptionPaneUI.this.getButtonInsets();
        }

        /* synthetic */ 8() {
        }
    }

    public static class SyncingLayoutManager
    implements LayoutManager,
    Serializable {
        protected boolean syncsAll;
        protected int padding;
        protected boolean centersChildren;

        public SyncingLayoutManager(boolean bl, int n) {
            this.syncsAll = bl;
            this.padding = n;
            this.centersChildren = true;
        }

        public void setSyncsAll(boolean bl) {
            this.syncsAll = bl;
        }

        public boolean getSyncsAll() {
            return this.syncsAll;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n;
                int n2;
                int n3 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n3];
                int n4 = container.getInsets().top;
                if (this.syncsAll) {
                    int n5;
                    int n6;
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < n3) {
                        dimensionArray[n8] = componentArray[n8].getPreferredSize();
                        n7 = Math.max(n7, dimensionArray[n8].width);
                        ++n8;
                    }
                    if (this.getCentersChildren()) {
                        n6 = (container.getSize().width - (n7 * n3 + (n3 - 1) * this.padding)) / 2;
                        n5 = this.padding + n7;
                    } else if (n3 > 1) {
                        n6 = 0;
                        n5 = (container.getSize().width - n7 * n3) / (n3 - 1) + n7;
                    } else {
                        n6 = (container.getSize().width - n7) / 2;
                        n5 = 0;
                    }
                    n8 = 0;
                    while (n8 < n3) {
                        componentArray[n8].setBounds(n6, n4, n7, dimensionArray[n8].height);
                        n6 += n5;
                        ++n8;
                    }
                    return;
                }
                int n9 = 0;
                int n10 = 0;
                while (n10 < n3) {
                    dimensionArray[n10] = componentArray[n10].getPreferredSize();
                    n9 += dimensionArray[n10].width;
                    ++n10;
                }
                n9 += (n3 - 1) * this.padding;
                boolean bl = this.getCentersChildren();
                if (bl) {
                    n2 = (container.getSize().width - n9) / 2;
                    n = this.padding;
                } else if (n3 > 1) {
                    n = (container.getSize().width - n9) / (n3 - 1);
                    n2 = 0;
                } else {
                    n2 = (container.getSize().width - n9) / 2;
                    n = 0;
                }
                n10 = 0;
                while (n10 < n3) {
                    componentArray[n10].setBounds(n2, n4, dimensionArray[n10].width, dimensionArray[n10].height);
                    n2 += n + dimensionArray[n10].width;
                    ++n10;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = insets.top + insets.bottom;
                if (this.syncsAll) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        Dimension dimension = componentArray[n5].getPreferredSize();
                        n2 = Math.max(n2, dimension.height);
                        n4 = Math.max(n4, dimension.width);
                        ++n5;
                    }
                    return new Dimension(n4 * n + (n - 1) * this.padding, n3 + n2);
                }
                int n6 = 0;
                int n7 = 0;
                while (n7 < n) {
                    Dimension dimension = componentArray[n7].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n6 += dimension.width;
                    ++n7;
                }
                return new Dimension(n6 += (n - 1) * this.padding, n3 + n2);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

