/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.DefaultSingleSelectionModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.SingleSelectionModel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.MenuBarUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private transient SingleSelectionModel selectionModel;
    private boolean paintBorder = true;
    private Insets margin;

    public JMenuBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuBarUI";
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public JMenu add(JMenu jMenu) {
        Dimension dimension = jMenu.getSize();
        dimension.height = Short.MAX_VALUE;
        super.add(jMenu);
        this.getUI().registerMenu(jMenu);
        return jMenu;
    }

    public JMenu getMenu(int n) {
        Component component = this.getComponentAtIndex(n);
        if (component instanceof JMenu) {
            return (JMenu)component;
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component instanceof JMenu) {
            this.getUI().unregisterMenu((JMenu)component);
        }
        super.remove(n);
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() not yet implemented.");
    }

    public Component getComponentAtIndex(int n) {
        int n2 = this.getComponentCount();
        if (n <= n2) {
            Component[] componentArray = this.getComponents();
            return componentArray[n];
        }
        return null;
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.invalidate();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
    }

    public MenuElement[] getSubElements() {
        int n = this.getMenuCount();
        MenuElement[] menuElementArray = new MenuElement[n];
        int n2 = 0;
        while (n2 < n) {
            menuElementArray[n2] = this.getMenu(n2);
            ++n2;
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    public boolean isManagingFocus() {
        return true;
    }

    JComponent.KeyboardBinding bindingForKeyStroke(KeyStroke keyStroke, int n) {
        JComponent.KeyboardBinding keyboardBinding = super.bindingForKeyStroke(keyStroke, n);
        if (keyboardBinding != null) {
            return keyboardBinding;
        }
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof JMenu) {
                keyboardBinding = JMenuBar.bindingForKeyStrokeRecursive(componentArray[n2], keyStroke, n);
            }
            if (keyboardBinding != null) {
                return keyboardBinding;
            }
            ++n2;
        }
        return null;
    }

    static JComponent.KeyboardBinding bindingForKeyStrokeRecursive(Component component, KeyStroke keyStroke, int n) {
        JMenu jMenu;
        Component[] componentArray;
        JComponent.KeyboardBinding keyboardBinding = null;
        if (component == null) {
            return null;
        }
        if (component instanceof JComponent && (keyboardBinding = ((JComponent)component).bindingForKeyStroke(keyStroke, n)) != null) {
            return keyboardBinding;
        }
        if (component instanceof JMenu && (componentArray = (jMenu = (JMenu)component).getMenuComponents()) != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof JMenuItem) {
                    keyboardBinding = JMenuBar.bindingForKeyStrokeRecursive(componentArray[n2], keyStroke, n);
                }
                if (keyboardBinding != null) {
                    return keyboardBinding;
                }
                ++n2;
            }
        }
        return keyboardBinding;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = new Object[4];
        int n = 0;
        if (this.selectionModel instanceof Serializable) {
            objectArray[n++] = "selectionModel";
            objectArray[n++] = this.selectionModel;
        }
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return;
            }
            if (objectArray[n].equals("selectionModel")) {
                this.selectionModel = (SingleSelectionModel)objectArray[n + 1];
            }
            n += 2;
        }
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            if (JMenuBar.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (JMenuBar.this.isSelected()) {
                if (n != 0) {
                    return null;
                }
                int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
                if (JMenuBar.this.getComponentAtIndex(n2) instanceof Accessible) {
                    return (Accessible)((Object)JMenuBar.this.getComponentAtIndex(n2));
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JMenuBar.this.getSelectionModel().getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
            JMenu jMenu;
            int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n == n2) {
                return;
            }
            if (n2 >= 0 && n2 < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n2)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(n);
            jMenu = JMenuBar.this.getMenu(n);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{JMenuBar.this, jMenu, jMenu.getPopupMenu()};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }

        public void removeAccessibleSelection(int n) {
            if (n >= 0 && n < JMenuBar.this.getMenuCount()) {
                JMenu jMenu = JMenuBar.this.getMenu(n);
                if (jMenu != null) {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
                JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
            }
        }

        public void clearAccessibleSelection() {
            JMenu jMenu;
            int n = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n >= 0 && n < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }

        AccessibleJMenuBar() {
            JMenuBar.this = JMenuBar.this;
        }
    }
}

