/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JCheckBoxMenuItem;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRadioButtonMenuItem;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.UnsupportedLookAndFeelException;
import com.sun.java.swing.border.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;

public class Mainwin
extends JFrame
implements ActionListener {
    RecordHandler mainTool;
    private ClogDisplay disp;
    private SwingWorker readWorker;
    private String setupFile = "jumpshot.setup";
    private String distributionDir = "./";
    String distributionUrl;
    private String classDir1 = "js_classes";
    private String classDir2 = "js_classes.jar";
    private String dataDir = "data";
    private String logFileDir = "logfiles";
    private Object openAppFileDlg;
    private ApltFileDlg openApltFileDlg;
    private MyTextField logFileField;
    String logFileName;
    private JMenuItem metalMenuItem;
    private JMenuItem selectFileMenuItem;
    Font frameFont;
    Color frameBColor;
    Color frameFColor;
    public Dimension dimPG;
    private HelpDlg helpDlg;
    private InputStream helpin;
    Mainwin startwin;
    private JMenuBar menuBar;
    private boolean child;
    boolean aplt;
    jumpshot parent;
    int dtype;
    private String about = "Jumpshot Logfile Analyzer V 1.2\nmpi-maint@mcs.anl.gov";
    private MyButton dispB;
    private boolean reader_alive;

    public Mainwin(jumpshot jumpshot2, String string, boolean bl, boolean bl2) {
        this.parent = jumpshot2;
        this.aplt = bl;
        this.child = bl2;
        this.logFileName = string;
        this.startwin = this;
        if (this.logFileName == null) {
            this.logFileName = new String("No Name");
        }
        this.setup();
    }

    private void setup() {
        this.setupUI();
        this.adjustFrameStuff();
        this.setupData();
        this.setupDlgs();
        this.setupPanels();
        this.disableDisp();
        this.setupEventHandlers();
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getMinimumSize());
        ((Frame)((Object)this)).setResizable(false);
        ((Component)((Object)this)).setVisible(true);
        if (!this.logFileName.equals("No Name")) {
            if (this.aplt) {
                this.logFileName = String.valueOf(this.distributionUrl) + this.logFileName;
            }
            this.readLogFile(this.logFileName);
        }
    }

    private void setupUI() {
        try {
            UIManager.setLookAndFeel((String)UIManager.getCrossPlatformLookAndFeelClassName());
            return;
        }
        catch (Exception exception) {
            new ErrorDiag(null, "Error loading L&F: " + exception);
            return;
        }
    }

    private void adjustFrameStuff() {
        if (this.child) {
            ((Frame)((Object)this)).setTitle("Jumpshot: (Child)");
        } else {
            ((Frame)((Object)this)).setTitle("Jumpshot");
        }
        Toolkit toolkit = ((Window)((Object)this)).getToolkit();
        Dimension dimension = new Dimension(toolkit.getScreenSize());
        this.dimPG = new Dimension((int)Math.rint((double)dimension.width * 0.75), (int)Math.rint((double)dimension.height * 0.5));
        this.frameBColor = Color.lightGray;
        this.frameFColor = Color.black;
        this.frameFont = new Font("Serif", 0, 10);
    }

    private void setupData() {
        InputStream inputStream;
        InputStream inputStream2;
        String string;
        Properties properties = new Properties();
        if (!this.aplt) {
            string = this.getDataPath();
            if (string == null) {
                new ErrorDiag(null, "Jumpshot cannot locate setup files. Exiting");
                return;
            }
            inputStream2 = this.getFileIn(String.valueOf(string) + this.setupFile);
        } else {
            string = this.getDataUrl();
            if (string == null) {
                new ErrorDiag(null, "Jumpshot cannot locate setup files. Exiting");
                return;
            }
            inputStream2 = this.getUrlIn(String.valueOf(string) + this.setupFile);
        }
        try {
            properties.load(inputStream2);
            inputStream2.close();
        }
        catch (IOException iOException) {
            new ErrorDiag((Component)((Object)this), "IO Error:" + iOException.getMessage());
            return;
        }
        String string2 = properties.getProperty("COLORFILE", "jumpshot.colors");
        String string3 = properties.getProperty("HELPFILE", "jumpshot.help");
        if (!this.aplt) {
            inputStream = this.getFileIn(String.valueOf(string) + string2);
            this.helpin = this.getFileIn(String.valueOf(string) + string3);
        } else {
            inputStream = this.getUrlIn(String.valueOf(string) + string2);
            this.helpin = this.getUrlIn(String.valueOf(string) + string3);
        }
        COLOR_UTIL.readColors(this, inputStream);
        this.reader_alive = false;
        this.mainTool = null;
    }

    private void setupDlgs() {
        if (!this.aplt) {
            Class<?> clazz = null;
            this.openAppFileDlg = null;
            try {
                clazz = Class.forName("com.sun.java.swing.preview.JFileChooser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName("com.sun.java.swing.JFileChooser");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    System.err.println(classNotFoundException2.toString());
                }
            }
            if (clazz != null) {
                try {
                    this.openAppFileDlg = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    System.err.println(instantiationException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(illegalAccessException.toString());
                }
            }
            if (this.openAppFileDlg != null) {
                File file = new File(System.getProperties().getProperty("user.dir"));
                String string = new String("Select Logfile");
                ROUTINES.invokeMethod(this.openAppFileDlg, "setDialogTitle", string, string.getClass());
                ROUTINES.invokeMethod(this.openAppFileDlg, "setCurrentDirectory", file, file.getClass());
                ROUTINES.invokeMethod(this.openAppFileDlg, "rescanCurrentDirectory", null, null);
            } else {
                this.selectFileMenuItem.setEnabled(false);
            }
        } else {
            this.openApltFileDlg = new ApltFileDlg(this, "Select Logfile");
        }
        this.helpDlg = new HelpDlg((Frame)((Object)this), this.readLines(this.helpin));
    }

    private void setupPanels() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.setupMenuBar(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        Border border = BorderFactory.createLoweredBevelBorder();
        JPanel jPanel = new JPanel((LayoutManager)new FlowLayout());
        Border border2 = BorderFactory.createEmptyBorder((int)4, (int)4, (int)2, (int)4);
        jPanel.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel.add((Component)new JLabel("Logfile"));
        this.logFileField = new MyTextField(this.logFileName, 35, false);
        jPanel.add((Component)((Object)this.logFileField));
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.dispB = new MyButton("Display", "Display loaded logfile", this);
        this.getContentPane().add((Component)((Object)this.dispB), gridBagConstraints);
    }

    private JMenuBar setupMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = this.menuBar.add(new JMenu("File"));
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("New Frame"));
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem.setHorizontalTextPosition(4);
        this.selectFileMenuItem = new JMenuItem("Select Logfile");
        jMenu.add(this.selectFileMenuItem);
        this.selectFileMenuItem.addActionListener((ActionListener)this);
        this.selectFileMenuItem.setHorizontalTextPosition(4);
        jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem.setHorizontalTextPosition(4);
        this.menuBar.add(jMenu);
        JMenu jMenu2 = this.menuBar.add(new JMenu("Display"));
        ButtonGroup buttonGroup = new ButtonGroup();
        DispListener dispListener = new DispListener();
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu2.add((JMenuItem)new JRadioButtonMenuItem("Time Lines"));
        buttonGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.addItemListener((ItemListener)dispListener);
        jRadioButtonMenuItem.setSelected(true);
        this.dtype = 0;
        jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu2.add((JMenuItem)new JRadioButtonMenuItem("Mountain Ranges"));
        buttonGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.addItemListener((ItemListener)dispListener);
        this.menuBar.add(jMenu2);
        JMenu jMenu3 = this.menuBar.add(new JMenu("System"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ToggleUIListener toggleUIListener = new ToggleUIListener();
        JRadioButtonMenuItem jRadioButtonMenuItem2 = (JRadioButtonMenuItem)jMenu3.add((JMenuItem)new JRadioButtonMenuItem("Windows Style Look and Feel"));
        jRadioButtonMenuItem2.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        buttonGroup2.add((AbstractButton)jRadioButtonMenuItem2);
        jRadioButtonMenuItem2.addItemListener((ItemListener)toggleUIListener);
        JRadioButtonMenuItem jRadioButtonMenuItem3 = (JRadioButtonMenuItem)jMenu3.add((JMenuItem)new JRadioButtonMenuItem("Motif Look and Feel"));
        jRadioButtonMenuItem3.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        buttonGroup2.add((AbstractButton)jRadioButtonMenuItem3);
        jRadioButtonMenuItem3.addItemListener((ItemListener)toggleUIListener);
        this.metalMenuItem = (JRadioButtonMenuItem)jMenu3.add((JMenuItem)new JRadioButtonMenuItem("Metal Look and Feel"));
        this.metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        this.metalMenuItem.setSelected(true);
        buttonGroup2.add((AbstractButton)this.metalMenuItem);
        this.metalMenuItem.addItemListener((ItemListener)toggleUIListener);
        JRadioButtonMenuItem jRadioButtonMenuItem4 = (JRadioButtonMenuItem)jMenu3.add((JMenuItem)new JRadioButtonMenuItem("Macintosh Look and Feel"));
        jRadioButtonMenuItem4.setSelected(UIManager.getLookAndFeel().getName().equals("Macintosh"));
        buttonGroup2.add((AbstractButton)jRadioButtonMenuItem4);
        jRadioButtonMenuItem4.addItemListener((ItemListener)toggleUIListener);
        jMenu3.add((Component)new JSeparator());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show ToolTips");
        jMenu3.add((JMenuItem)jCheckBoxMenuItem);
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener((ActionListener)new 1());
        JMenu jMenu4 = this.menuBar.add(new JMenu("Help"));
        jMenuItem = jMenu4.add(new JMenuItem("Manual"));
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem = jMenu4.add(new JMenuItem("About"));
        jMenuItem.addActionListener((ActionListener)this);
        this.menuBar.add(jMenu4);
        return this.menuBar;
    }

    private void setupEventHandlers() {
        ((Component)((Object)this)).enableEvents(128L);
        ((Window)((Object)this)).addWindowListener(new 2());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("New Frame")) {
            new Mainwin(this.parent, null, this.aplt, true);
            return;
        }
        if (string.equals("Select Logfile")) {
            this.selectFile();
            return;
        }
        if (string.equals("Exit")) {
            this.close();
            return;
        }
        if (string.equals("Manual")) {
            ((Component)((Object)this.helpDlg)).setVisible(true);
            return;
        }
        if (string.equals("About")) {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)this.about, (String)"About", (int)1, (Icon)this.loadImageIcon("images/jumpshot.gif"));
            return;
        }
        if (string.equals("Display")) {
            this.displayStuff();
        }
    }

    private void displayStuff() {
        if (this.mainTool != null) {
            this.disableDisp();
            this.waitCursor();
            this.disp = new ClogDisplay(this);
            this.normalCursor();
        }
    }

    private void disableDisp() {
        this.dispB.setEnabled(false);
    }

    private void enableDisp() {
        this.dispB.setEnabled(true);
    }

    private void selectFile() {
        if (!this.aplt) {
            Class<?> clazz = this.getClass();
            while (!clazz.getName().equals("java.awt.Component")) {
                clazz = clazz.getSuperclass();
            }
            int n = (Integer)ROUTINES.invokeMethod(this.openAppFileDlg, "showOpenDialog", this, clazz);
            if (n == 0) {
                File file = (File)ROUTINES.invokeMethod(this.openAppFileDlg, "getSelectedFile", null, null);
                String string = file != null ? file.toString() : null;
                if (string != null) {
                    this.logFileName = string;
                    this.logFileField.setText(this.logFileName);
                    this.readLogFile(this.logFileName);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)"No file chosen");
            }
            return;
        }
        ((Dialog)((Object)this.openApltFileDlg)).show();
        if (this.openApltFileDlg.select) {
            String string = this.openApltFileDlg.getFile();
            if (string != null) {
                this.logFileName = string;
                this.logFileField.setText(this.logFileName);
                this.readLogFile(this.logFileName);
                return;
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)"No file chosen");
        }
    }

    private void readLogFile(String string) {
        this.freeMem();
        this.readWorker = new 3();
    }

    private void close() {
        this.freeMem();
        ((Component)((Object)this)).setVisible(false);
        ((Window)((Object)this)).dispose();
        if (!this.child && !this.aplt) {
            System.exit(0);
        }
    }

    private void freeMem() {
        if (this.reader_alive) {
            this.readWorker.interrupt();
            this.readWorker = null;
        }
        if (this.disp != null) {
            this.disp.kill();
        }
        this.mainTool = null;
    }

    void normalCursor() {
        ROUTINES.makeCursor((Component)((Object)this), new Cursor(0));
    }

    void waitCursor() {
        ROUTINES.makeCursor((Component)((Object)this), new Cursor(3));
    }

    private String readLines(InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = String.valueOf(string) + string2 + "\n";
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            new ErrorDiag((Component)((Object)this), "IO Error:" + iOException.getMessage());
        }
        return string;
    }

    private InputStream getFileIn(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new ErrorDiag((Component)((Object)this), "file: " + string + " not found.");
            return null;
        }
        return fileInputStream;
    }

    private InputStream getUrlIn(String string) {
        URL uRL = null;
        InputStream inputStream = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            new ErrorDiag((Component)((Object)this), "Bad URL:" + uRL);
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            new ErrorDiag((Component)((Object)this), "IO Error:" + iOException.getMessage());
            return null;
        }
        return inputStream;
    }

    private String getDataPath() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String string2;
                File file = new File(stringTokenizer.nextToken());
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    new ErrorDiag((Component)((Object)this), "IO Exception:" + iOException.getMessage());
                    break block5;
                }
                if (string2.endsWith(this.classDir1)) {
                    this.distributionDir = string2.substring(0, string2.lastIndexOf(this.classDir1));
                    return String.valueOf(this.distributionDir) + this.dataDir + File.separator;
                }
                if (string2.endsWith(this.classDir2)) {
                    this.distributionDir = string2.substring(0, string2.lastIndexOf(this.classDir2));
                    return String.valueOf(this.distributionDir) + this.dataDir + File.separator;
                }
            }
            ++n2;
        }
        new ErrorDiag(null, "Neither of " + this.classDir1 + " nor " + this.classDir2 + " could be found" + " in java.class.classpath");
        return null;
    }

    private String getDataUrl() {
        String string = this.parent.getCodeBase().toString();
        int n = string.lastIndexOf(this.classDir1);
        this.distributionUrl = n == -1 ? string : string.substring(0, n);
        return String.valueOf(this.distributionUrl) + this.dataDir + "/";
    }

    private ImageIcon loadImageIcon(String string) {
        if (!this.aplt) {
            return new ImageIcon(String.valueOf(this.distributionDir) + string);
        }
        URL uRL = null;
        try {
            uRL = new URL(String.valueOf(this.distributionUrl) + string);
        }
        catch (MalformedURLException malformedURLException) {
            new ErrorDiag((Component)((Object)this), "Bad URL:" + uRL);
            return null;
        }
        return new ImageIcon(uRL);
    }

    void delDisp() {
        this.enableDisp();
        this.disp = null;
    }

    private void makeUIChanges() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        ((Frame)((Object)this)).setResizable(true);
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getMinimumSize());
        ((Frame)((Object)this)).setResizable(false);
        if (!this.aplt) {
            SwingUtilities.updateComponentTreeUI((Component)((Component)this.openAppFileDlg));
        } else {
            SwingUtilities.updateComponentTreeUI((Component)((Object)this.openApltFileDlg));
        }
        SwingUtilities.updateComponentTreeUI((Component)((Object)this.helpDlg));
        if (this.disp != null) {
            this.disp.makeUIChanges();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    static /* synthetic */ boolean access$2(Mainwin mainwin) {
        return mainwin.reader_alive;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (jCheckBoxMenuItem.isSelected()) {
                ToolTipManager.sharedInstance().setEnabled(true);
                return;
            }
            ToolTipManager.sharedInstance().setEnabled(false);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Mainwin.this.close();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends SwingWorker {
        public Object construct() {
            Mainwin.this.waitCursor();
            Mainwin.this.disableDisp();
            Mainwin.this.reader_alive = true;
            return new ClogReader((JFrame)Mainwin.this.startwin, (String)Mainwin.this.logFileName, (boolean)Mainwin.this.aplt).mainTool;
        }

        public void finished() {
            Mainwin.this.reader_alive = false;
            Mainwin.this.mainTool = (RecordHandler)this.get();
            Mainwin.this.normalCursor();
            if (Mainwin.this.mainTool != null) {
                Mainwin.this.enableDisp();
            }
            Mainwin.this.displayStuff();
        }

        /* synthetic */ 3() {
        }
    }

    private class ToggleUIListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Mainwin.this.waitCursor();
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            try {
                if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Windows Style Look and Feel")) {
                    UIManager.setLookAndFeel((String)"com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    Mainwin.this.makeUIChanges();
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Macintosh Look and Feel")) {
                    UIManager.setLookAndFeel((String)"com.sun.java.swing.plaf.mac.MacLookAndFeel");
                    Mainwin.this.makeUIChanges();
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Motif Look and Feel")) {
                    UIManager.setLookAndFeel((String)"com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    Mainwin.this.makeUIChanges();
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Metal Look and Feel")) {
                    UIManager.setLookAndFeel((String)"com.sun.java.swing.plaf.metal.MetalLookAndFeel");
                    Mainwin.this.makeUIChanges();
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                jRadioButtonMenuItem.setEnabled(false);
                new ErrorDiag(null, "Unsupported LookAndFeel: " + jRadioButtonMenuItem.getText() + ".\nLoading cross platform look and feel");
                try {
                    Mainwin.this.metalMenuItem.setSelected(true);
                    UIManager.setLookAndFeel((String)UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI((Component)((Object)Mainwin.this.startwin));
                }
                catch (Exception exception) {
                    new ErrorDiag(null, "Could not load LookAndFeel: " + exception);
                }
            }
            catch (Exception exception) {
                jRadioButtonMenuItem.setEnabled(false);
                new ErrorDiag(null, "Could not load LookAndFeel: " + jRadioButtonMenuItem.getText());
            }
            Mainwin.this.normalCursor();
        }

        ToggleUIListener() {
            Mainwin.this = Mainwin.this;
        }
    }

    private class DispListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Mountain Ranges")) {
                Mainwin.this.dtype = 1;
                return;
            }
            if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Time Lines")) {
                Mainwin.this.dtype = 0;
            }
        }

        DispListener() {
            Mainwin.this = Mainwin.this;
        }
    }
}

