/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;

public class HistImage {
    HistCanvas parent;
    double begT;
    double endT;
    int _xPix;
    int _yPix;
    Image img;
    int statesDrawn;
    int highestCt;
    int max = 6;

    public HistImage(Image image, int n, int n2, HistCanvas histCanvas) {
        this.img = image;
        this._xPix = n;
        this._yPix = n2;
        this.parent = histCanvas;
    }

    public HistImage(int n, int n2, HistCanvas histCanvas) {
        this._xPix = n;
        this._yPix = n2;
        this.parent = histCanvas;
    }

    void drawRegion(double d, double d2) {
        this.begT = d;
        this.endT = d2;
        this.drawStuff(this.img.getGraphics());
    }

    void drawRegionOnGraphics(double d, double d2, Graphics graphics) {
        this.begT = d;
        this.endT = d2;
        this.drawStuff(graphics);
    }

    void drawStuff(Graphics graphics) {
        if (graphics instanceof PrintGraphics) {
            graphics.setColor(this.parent.parent.parent.printImgBColor);
        } else {
            graphics.setColor(this.parent.parent.parent.normImgBColor);
        }
        graphics.fillRect(0, 0, this._xPix, this._yPix - 3 * this.parent.lineSize);
        this.drawBins(graphics);
        this.drawTimeLine(graphics);
    }

    void drawStuff() {
        this.drawStuff(this.img.getGraphics());
    }

    /*
     * Unable to fully structure code
     */
    private void drawBins(Graphics var1_1) {
        var2_2 = (this.endT - this.begT) / (double)this.parent.numBins;
        var4_3 = 0;
        this.statesDrawn = 0;
        this.highestCt = 0;
        var5_4 = this.parent.stateDef.stateVector;
        var6_5 = 0;
        while (var6_5 < this.parent.numBins) {
            var7_6 = this.begT + (double)var6_5 * var2_2;
            var9_7 = this.begT + (double)(var6_5 + 1) * var2_2;
            var11_8 = 0;
            if (true) ** GOTO lbl17
            do {
                if (var7_6 <= var12_9.lenT) {
                    ++var11_8;
                    ++this.statesDrawn;
                }
                ++var4_3;
lbl17:
                // 2 sources

                if (var4_3 >= var5_4.size()) break;
                var12_9 = (Info)var5_4.elementAt(var4_3);
            } while (var12_9.lenT < var9_7 || var12_9.lenT == var9_7 && var12_9.lenT == this.endT);
            if (this.highestCt < var11_8) {
                this.highestCt = var11_8;
            }
            if (var11_8 > 0) {
                this.drawBin(var1_1, var6_5, var11_8);
            }
            ++var6_5;
        }
    }

    protected void drawBin(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.parent.getHistHeight(n2);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > this._yPix - 3 * this.parent.lineSize) {
            n4 = this._yPix - 3 * this.parent.lineSize;
        }
        if ((n3 = (int)Math.rint((double)(n * this._xPix) / (double)this.parent.numBins)) >= this._xPix) {
            n3 = this._xPix - 1;
        }
        int n5 = n3;
        int n6 = (int)Math.rint((double)((n + 1) * this._xPix) / (double)this.parent.numBins);
        int n7 = n6;
        int n8 = n7 - n5;
        if (n8 == 0) {
            n8 = 1;
        }
        int n9 = this._yPix - 3 * this.parent.lineSize - n4;
        graphics.setColor(this.parent.stateDef.color);
        graphics.fillRect(n5, n9, n8, n4);
    }

    private void drawTimeLine(Graphics graphics) {
        graphics.setColor(this.parent.parent.parent.rulerColor);
        graphics.fillRect(0, this._yPix - 3 * this.parent.lineSize, this._xPix, 3 * this.parent.lineSize);
        graphics.setColor(Color.black);
        graphics.drawLine(0, this._yPix - 3 * this.parent.lineSize, this._xPix, this._yPix - 3 * this.parent.lineSize);
        double d = this.parent.getTime(this.parent.dpi);
        if (d <= 0.0) {
            return;
        }
        int n = (int)Math.rint(this.begT / d);
        double d2 = (double)n * d;
        while (d2 < this.endT) {
            String string;
            int n2;
            int n3 = n * this.parent.dpi - this.parent.getEvtXCord(this.begT) - (int)Math.rint((double)this.parent.fm.charWidth('|') / 2.0);
            graphics.drawString("|", n3, this._yPix - 2 * this.parent.lineSize - this.parent.fDescent);
            String string2 = new Float(d2).toString();
            if (string2.indexOf(69) == -1) {
                n2 = this.max;
                if (n2 > string2.length()) {
                    n2 = string2.length();
                }
                string = string2.substring(0, n2);
            } else {
                n2 = string2.indexOf(69);
                String string3 = string2.substring(n2, string2.length());
                int n4 = 5;
                if (n2 < n4) {
                    n4 = n2;
                }
                String string4 = string2.substring(0, n4);
                string = String.valueOf(string4) + string3;
            }
            graphics.drawString(string, n3 - (int)Math.rint((double)this.parent.fm.stringWidth(string) / 2.0), this._yPix - (this.parent.lineSize + this.parent.fDescent));
            d2 = (double)(++n) * d;
        }
    }

    void kill() {
        if (this.img != null) {
            this.img.flush();
            this.img = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

