/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: rpisys.h,v 6.9 1999/11/12 05:19:23 jsquyres Exp $
 *
 *	Function:	- RPI dependent structures
 */

#ifndef _RPISYS_H
#define _RPISYS_H

#include <sys/types.h>

#include <app_mgmt.h>
#include <mpi.h>
#include <rpi.c2c.h>
#include <rpi.lamd.h>

/*
 * Interface specific client-to-client header file.
 */
#if (LAM_RPI_SHM_SYSV || LAM_RPI_SHM_USYSV)
#include <rpi.shm.h>

#elif LAM_RPI_TCP
#include <rpi.tcp.h>

#else

Error: Invalid RPI type.

#endif

/*
 * RPI specific part of process structure.  Currently there is no LAM
 * daemon specific part.  
 */
union rpi_proc {
	struct c2c_proc	c2c;			/* client-to-client data */
};

struct _proc {
	struct _gps	p_gps;			/* process GPS */
	int		p_ger_nsnd;		/* #msgs sent there */
	int		p_mode;			/* mode flags */
#define LAM_PFLAG	0x001			/* used for marking */
#define LAM_PDEAD	0x002			/* node died */
#define LAM_PRPIINIT	0x004			/* RPI initialized */
#define LAM_PCLIENT	0x008			/* in client world */
#define LAM_PHOMOG	0x010			/* homogeneous */
	int		p_refcount;		/* reference count */
	union rpi_proc	p_rpi;			/* RPI specific stuff */
};

union rpi_req {
	struct lamd_req	lamd;			/* LAM daemon mode req. data */
	struct c2c_req	c2c;			/* client-to-client req. data */
};

struct _req {
	int		rq_type;
#define LAM_RQISEND	0
#define LAM_RQIBSEND	1
#define LAM_RQISSEND	2
#define LAM_RQIRSEND	3
#define LAM_RQIRECV	4
#define LAM_RQIPROBE	5
#define LAM_RQIFAKE	6
	int		rq_state;
#define LAM_RQSINIT	0			/* request initialized */
#define LAM_RQSSTART	1			/* active, nothing done yet */
#define LAM_RQSACTIVE	4			/* active, undone request */
#define LAM_RQSDONE	3			/* request done */
	int		rq_marks;		/* persistent flags */
#define LAM_RQFPERSIST	0x0001			/* persistent request */
#define LAM_RQFDYNBUF	0x0004			/* dynamic buffer */
#define LAM_RQFDYNREQ	0x0008			/* dynamic request */
#define LAM_RQFSOURCE	0x0200			/* source request */
#define LAM_RQFDEST	0x0400			/* destination request */
#define LAM_RQFBLKTYPE	0x0800			/* blocking request type */
#define LAM_RQFOSORIG	0x1000			/* origin 1-sided req. type */
#define LAM_RQFOSTARG	0x2000			/* target 1-sided req. type */
#define LAM_RQFMAND	0x4000			/* mandatory req-must finish */
	int		rq_flags;		/* active req flags */
#define LAM_RQFCANCEL	0x0002			/* cancelled request */
#define LAM_RQFBLOCK	0x0010			/* blocking request */
#define LAM_RQFTRUNC	0x0040			/* truncated message */
#define LAM_RQFHDLDONE	0x0040			/* handler has been invoked */
#define LAM_RQFORPHAN	0x0100			/* destroy when done */
#define LAM_RQFCHAR	0x0100000		/* == DRAWMSG */
#define LAM_RQFINT	0x0200000		/* == DINT4MSG */
#define LAM_RQFFLOAT	0x0400000		/* == DFLT4MSG */
#define LAM_RQFDOUBLE	0x0800000		/* == DFLT8MSG */
#define LAM_RQFSHORT	0x01000000		/* == DINT2MSG */
#define LAM_RQFMARK	0x02000000		/* arbitrary mark */
#define LAM_RQFACKDONE	0x04000000		/* ACK is done */
	char		*rq_packbuf;		/* pack buffer */
	int		rq_packsize;		/* pack buffer size */
	int		rq_count;		/* MPI request parameter */
	void		*rq_buf;		/* MPI request parameter */
	MPI_Datatype	rq_dtype;		/* MPI request parameter */
	int		rq_rank;		/* MPI request parameter */
	int		rq_tag;			/* MPI request parameter */
	MPI_Comm	rq_comm;		/* MPI request parameter */
	int		rq_cid;			/* context ID to use */
	int		rq_func;		/* MPI func. which made req. */
	int		rq_seq;			/* seq# of associated msg */
	int		rq_f77handle;		/* F77 handle */
	MPI_Status	rq_status;		/* status info storage */
	struct _bsndhdr	*rq_bsend;		/* bsend header */
	struct _proc	*rq_proc;		/* peer process */
	struct _req	*rq_next;		/* next request */
	void		*rq_extra;		/* extra state */
	int		(*rq_hdlr)();		/* handler function */
        MPI_Request     rq_shadow;              /* shadow IMPI requests */
	union rpi_req	rq_rpi;			/* RPI specific stuff */
};

#endif	/* _RPISYS_H */
