/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: mpi_types.h,v 6.8 1999/09/27 12:13:35 lamteam Exp $
 *
 *	Function:	- type conversions for ANSI C types and alignment
 *			  checking
 */

#ifndef _MPI_TYPES_H
#define _MPI_TYPES_H

#include <lam_config.h>
#include <mpi.h>
#include <t_types.h>

#if WORDS_BIGENDIAN

#define	ttol_short(x, y)	(*((short *) (y)) = *((short *) (x)))
#define	ltot_short(x, y)	(*((short *) (y)) = *((short *) (x)))
#define	mttol_short(x, l)
#define	mltot_short(x, l)

#define	ttol_int(x, y)		(*((int *) (y)) = *((int *) (x)))
#define	ltot_int(x, y)		(*((int *) (y)) = *((int *) (x)))
#define	mttol_int(x, l)
#define	mltot_int(x, l)

#define	ttol_wchar(x, y)	(*((wchar_t *) (y)) = *((wchar_t *) (x)))
#define	ltot_wchar(x, y)	(*((wchar_t *) (y)) = *((wchar_t *) (x)))
#define	mttol_wchar(x, l)
#define	mltot_wchar(x, l)

#define	ttol_long(x, y)		(*((long *) (y)) = *((long *) (x)))
#define	ltot_long(x, y)		(*((long *) (y)) = *((long *) (x)))
#define	mttol_long(x, l)
#define	mltot_long(x, l)

#if LAM_SIZEOF_LONG_LONG
#define	ttol_longlong(x, y)	(*((long long *) (y)) = *((long long *) (x)))
#define	ltot_longlong(x, y)	(*((long long *) (y)) = *((long long *) (x)))
#define	mttol_longlong(x, l)
#define	mltot_longlong(x, l)
#endif

#define	ttol_float(x, y)	(*((float *) (y)) = *((float *) (x)))
#define	ltot_float(x, y)	(*((float *) (y)) = *((float *) (x)))
#define	mttol_float(x, l)
#define	mltot_float(x, l)

#define	ttol_double(x, y)	(*((double *) (y)) = *((double *) (x)))
#define	ltot_double(x, y)	(*((double *) (y)) = *((double *) (x)))
#define	mttol_double(x, l)
#define	mltot_double(x, l)

#if LAM_SIZEOF_LONG_DOUBLE
#define ttol_longdbl(x, y)	(*((long double*) (y)) = *((long double*) (x)))
#define ltot_longdbl(x, y)	(*((long double*) (y)) = *((long double*) (x)))
#define	mttol_longdbl(x, l)
#define	mltot_longdbl(x, l)
#endif

#else  /* not WORDS_BIGENDIAN */

#if LAM_SIZEOF_SHORT == 2
#define	ttol_short(x, y)	revn(x, y, 2)
#define	ltot_short(x, y)	revn(x, y, 2)
#define	mttol_short(x, l)	mrevn(x, 2, l)
#define	mltot_short(x, l)	mrevn(x, 2, l)
#elif LAM_SIZEOF_SHORT == 4
#define	ttol_short(x, y)	rev4(x, y)
#define	ltot_short(x, y)	rev4(x, y)
#define	mttol_short(x, l)	mrev4(x, l)
#define	mltot_short(x, l)	mrev4(x, l)
#endif

#if LAM_SIZEOF_INT == 4
#define	ttol_int(x, y)		rev4(x, y)
#define	ltot_int(x, y)		rev4(x, y)
#define	mttol_int(x, l)		mrev4(x, l)
#define	mltot_int(x, l)		mrev4(x, l)
#elif LAM_SIZEOF_INT == 8
#define	ttol_int(x, y)		rev8(x, y)
#define	ltot_int(x, y)		rev8(x, y)
#define	mttol_int(x, l)		mrev8(x, l)
#define	mltot_int(x, l)		mrev8(x, l)
#endif

#if LAM_SIZEOF_WCHAR == 4
#define	ttol_wchar(x, y)	rev4(x, y)
#define	ltot_wchar(x, y)	rev4(x, y)
#define	mttol_wchar(x, l)	mrev4(x, l)
#define	mltot_wchar(x, l)	mrev4(x, l)
#endif

#if LAM_SIZEOF_LONG == 4
#define	ttol_long(x, y)		rev4(x, y)
#define	ltot_long(x, y)		rev4(x, y)
#define	mttol_long(x, l)	mrev4(x, l)
#define	mltot_long(x, l)	mrev4(x, l)
#elif LAM_SIZEOF_LONG == 8
#define	ttol_long(x, y)		rev8(x, y)
#define	ltot_long(x, y)		rev8(x, y)
#define	mttol_long(x, l)	mrev8(x, l)
#define	mltot_long(x, l)	mrev8(x, l)
#endif

#if LAM_SIZEOF_LONG_LONG == 8
#define	ttol_longlong(x, y)	rev8(x, y)
#define	ltot_longlong(x, y)	rev8(x, y)
#define	mttol_longlong(x, l)	mrev8(x, l)
#define	mltot_longlong(x, l)	mrev8(x, l)
#elif LAM_SIZEOF_LONG_LONG
#define	ttol_longlong(x, y)	revn(x, y, LAM_SIZEOF_LONG_LONG)
#define	ltot_longlong(x, y)	revn(x, y, LAM_SIZEOF_LONG_LONG)
#define	mttol_longlong(x, l)	mrevn(x, LAM_SIZEOF_LONG_LONG, l)
#define	mltot_longlong(x, l)	mrevn(x, LAM_SIZEOF_LONG_LONG, l)
#endif

#if LAM_SIZEOF_FLOAT == 4
#define	ttol_float(x, y)	rev4(x, y)
#define	ltot_float(x, y)	rev4(x, y)
#define	mttol_float(x, l)	mrev4(x, l)
#define	mltot_float(x, l)	mrev4(x, l)
#elif LAM_SIZEOF_FLOAT == 8
#define	ttol_float(x, y)	rev8(x, y)
#define	ltot_float(x, y)	rev8(x, y)
#define	mttol_float(x, l)	mrev8(x, l)
#define	mltot_float(x, l)	mrev8(x, l)
#endif

#if LAM_SIZEOF_DOUBLE == 8
#define	ttol_double(x, y)	rev8(x, y)
#define	ltot_double(x, y)	rev8(x, y)
#define	mttol_double(x, l)	mrev8(x, l)
#define	mltot_double(x, l)	mrev8(x, l)
#elif LAM_SIZEOF_DOUBLE
#define	ttol_double(x, y)	revn(x, y, LAM_SIZEOF_DOUBLE)
#define	ltot_double(x, y)	revn(x, y, LAM_SIZEOF_DOUBLE)
#define	mttol_double(x, l)	mrevn(x, LAM_SIZEOF_DOUBLE, l)
#define	mltot_double(x, l)	mrevn(x, LAM_SIZEOF_DOUBLE, l)
#endif

#if LAM_SIZEOF_LONG_DOUBLE == 8
#define	ttol_longdbl(x, y)	rev8(x, y)
#define	ltot_longdbl(x, y)	rev8(x, y)
#define	mttol_longdbl(x, l)	mrev8(x, l)
#define	mltot_longdbl(x, l)	mrev8(x, l)
#elif LAM_SIZEOF_LONG_DOUBLE
#define	ttol_longdbl(x, y)	revn(x, y, LAM_SIZEOF_LONG_DOUBLE)
#define	ltot_longdbl(x, y)	revn(x, y, LAM_SIZEOF_LONG_DOUBLE)
#define	mttol_longdbl(x, l)	mrevn(x, LAM_SIZEOF_LONG_DOUBLE, l)
#define	mltot_longdbl(x, l)	mrevn(x, LAM_SIZEOF_LONG_DOUBLE, l)
#endif

#endif  /* not WORDS_BIGENDIAN */

#ifdef __cplusplus
extern "C" {
#endif

extern void		lam_copyrev2 __ARGS((void *, void *, int));
extern void		lam_copyrev4 __ARGS((void *, void *, int));
extern void		lam_copyrev8 __ARGS((void *, void *, int));
extern void		lam_copyrevn __ARGS((void *, void *, int, int));

#ifdef __cplusplus
}
#endif

#endif /* _MPI_TYPES_H */
