/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *      Revision 6.2  1999/03/17 14:19:40  jsquyres
 *
 *      Revision 6.1  1996/11/23 21:55:04  nevin
 *      Ohio Release
 *
 * Revision 6.0  96/02/29  13:53:28  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/18  01:26:58  gdburns
 * major overhaul
 * 
 * Revision 5.2  94/08/22  14:00:37  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:28  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:48:55  gdburns
 * Ohio Release
 * 
 *	Function:	- constants and templates associated with the
 *			  runtime trace system
 */

#ifndef _KTRACE
#define _KTRACE

#include <lam_config.h>
#include <portable.h>

/*
 * trace header
 */
struct trhead {
	char		*trh_buf;	/* trace buffer ptr */
	int4		trh_length;	/* trace buffer length */
};

/*
 * constants
 */
#define TRHMAX		4		/* TRHMAX * MAXNMSGLEN = len limit */
#define TRHQUAN		2		/* TRHQUAN * MAXNMSGLEN = alloc hunk */

#ifdef __cplusplus
extern "C" {
#endif

extern char		*lam_trpoint __ARGS((int4 size));
extern void		lam_trexit __ARGS((void));
extern void		lam_trinit __ARGS((void));
extern void		lam_trunload __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _KTRACE */
