/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	Function:	- F77 constants and structures associated with the
 *			  network subsystem
 *			- based on Trollius 2.0 Copyright 1992
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 */

#ifndef _NETF
#define _NETF

/*
 * network constants
 */
#define	LOCAL		(-2147483647)	/* on the local node */
#define	MAXNMSGLEN	(4096)		/* maximum network frame size */
#define	NOTNODEID	(-2147483648)	/* not a valid node ID */
#define	NOTNODETYPE	(-2147483648)	/* not a valid node type */
#define	ORIGIN		(IGORGN())	/* should be user's node */

/*
 * node types
 */
#define NTOTB		(0)		/* OTB, not-ITB */
#define NTITB		(1)		/* ITB, not-OTB */
#define NTCAST		(2)		/* a multicast of nodes */
#define NTWASTE		(4)		/* not fully used/wasted */
#define NTDISK		(8)		/* node has a disk */
#define NTTUBE		(16)		/* node has a video unit */
#define NTJONES		(32)		/* neighbour node */
#define NTBOOT		(64)		/* child node in boot tree */
#define NTALL		(127)		/* match any bit-flag */

/*
 * predefined cast identifiers (implies a nodeid set and a nodeid source)
 */
#define HOST2ALL	(-2147483646)	/* origin to all nodes */
#define HOST2ITB	(-2147483645)	/* origin to all ITB nodes */
#define HOST2OTB	(-2147483643)	/* origin to all OTB nodes */
#define HOST2COMP	(-2147483642)	/* origin to all compute nodes */

/*
 * network message header
 */
#define NHDSIZE		8		/* # of data words in header */

#define NOBUF		(16)		/* don't do buffering at all */
#define NREEL		(1024)		/* multireel */
#define DRAWDATA	(65536)		/* don't touch data pouch */
#define DINT4DATA	(131072)	/* data pouch is integers */
#define DFLT4DATA	(262144)	/* data pouch is floats */
#define DFTL8DATA	(524288)	/* data pouch is doubles */
#define DRAWMSG		(1048576)	/* don't touch message */
#define DINT4MSG	(2097152)	/* message is integers */
#define DFLT4MSG	(4194304)	/* message is floats */
#define DFLT8MSG	(8388608)	/* message is doubles */

/*
 * process runtime flags
 */
#define RTF_SYSGEN	(8)		/* system generated process */
#define RTF_WAIT	(16)		/* notify parent on child exit */
#define RTF_TRACE	(256)		/* enable tracing */
#define RTF_TRSWITCH	(512)		/* start with tracing on/off */

#endif
