/* Drawing object marker for XGDrawContext

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef _XGDrawObject_h_INCLUDE
#define _XGDrawObject_h_INCLUDE

#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>

typedef enum {
  ctxt_mark, path_moveto, path_rmoveto, path_lineto, path_rlineto,
  path_arc, path_curveto,
  path_charpath, path_closepath,
  path_stroke, path_fill, path_eofill, path_clip, path_eoclip,
  path_viewclip, path_eoviewclip
} ctxt_object_t;

@interface XGDrawObject : NSObject
{
  ctxt_object_t type;
  NSPoint point;
}

- initWithDrawType: (ctxt_object_t)theType;
- initWithDrawType: (ctxt_object_t)theType point: (NSPoint)thePoint;

- (ctxt_object_t)drawType;
- (NSPoint) drawPoint;

@end

#endif /* _XGDrawObject_h_INCLUDE */
