indexing
	description: "Wrapper for GtkList"
	author: "Generated by the GOTE"
	status: "See important notice at end of file."

class
	GTK_LIST

inherit
	GTK_CONTAINER
		rename
			get_type as gtk_container_get_type
		end

create
	make_from_c_pointer,
	make

feature

	get_type: INTEGER is
		do
			Result := c_gtk_list.gtk_list_get_type
		end

	make is
		do
			make_from_c_pointer (c_gtk_list.gtk_list_new)
		end

	insert_items (a_items: POINTER; a_position: INTEGER) is
		do
			c_gtk_list.gtk_list_insert_items (c_object, a_items, a_position)
		end

	append_items (a_items: POINTER) is
		do
			c_gtk_list.gtk_list_append_items (c_object, a_items)
		end

	prepend_items (a_items: POINTER) is
		do
			c_gtk_list.gtk_list_prepend_items (c_object, a_items)
		end

	remove_items (a_items: POINTER) is
		do
			c_gtk_list.gtk_list_remove_items (c_object, a_items)
		end

	remove_items_no_unref (a_items: POINTER) is
		do
			c_gtk_list.gtk_list_remove_items_no_unref (c_object, a_items)
		end

	clear_items (a_start: INTEGER; a_end: INTEGER) is
		do
			c_gtk_list.gtk_list_clear_items (c_object, a_start, a_end)
		end

	select_item (a_item: INTEGER) is
		do
			c_gtk_list.gtk_list_select_item (c_object, a_item)
		end

	unselect_item (a_item: INTEGER) is
		do
			c_gtk_list.gtk_list_unselect_item (c_object, a_item)
		end

	select_child (a_child: gtk_widget) is
		do
			c_gtk_list.gtk_list_select_child (c_object, a_child.c_object)
		end

	unselect_child (a_child: gtk_widget) is
		do
			c_gtk_list.gtk_list_unselect_child (c_object, a_child.c_object)
		end

	child_position (a_child: gtk_widget): INTEGER is
		do
			Result := c_gtk_list.gtk_list_child_position (c_object, a_child.c_object)
		end

	set_selection_mode (a_mode: INTEGER) is
		do
			c_gtk_list.gtk_list_set_selection_mode (c_object, a_mode)
		end

	extend_selection (a_scroll_type: INTEGER; a_position: REAL; a_auto_start_selection: BOOLEAN) is
		do
			c_gtk_list.gtk_list_extend_selection (c_object, a_scroll_type, a_position, a_auto_start_selection)
		end

	start_selection is
		do
			c_gtk_list.gtk_list_start_selection (c_object)
		end

	end_selection is
		do
			c_gtk_list.gtk_list_end_selection (c_object)
		end

	select_all is
		do
			c_gtk_list.gtk_list_select_all (c_object)
		end

	unselect_all is
		do
			c_gtk_list.gtk_list_unselect_all (c_object)
		end

	scroll_horizontal (a_scroll_type: INTEGER; a_position: REAL) is
		do
			c_gtk_list.gtk_list_scroll_horizontal (c_object, a_scroll_type, a_position)
		end

	scroll_vertical (a_scroll_type: INTEGER; a_position: REAL) is
		do
			c_gtk_list.gtk_list_scroll_vertical (c_object, a_scroll_type, a_position)
		end

	toggle_add_mode is
		do
			c_gtk_list.gtk_list_toggle_add_mode (c_object)
		end

	toggle_focus_row is
		do
			c_gtk_list.gtk_list_toggle_focus_row (c_object)
		end

	toggle_row (a_item: gtk_widget) is
		do
			c_gtk_list.gtk_list_toggle_row (c_object, a_item.c_object)
		end

	undo_selection is
		do
			c_gtk_list.gtk_list_undo_selection (c_object)
		end

	end_drag_selection is
		do
			c_gtk_list.gtk_list_end_drag_selection (c_object)
		end

	connect_selection_changed_signal (function: POINTER; data: POINTER): INTEGER is
			-- Connect `function' to the "selection_changed" signal.
			-- `data' will be passed back when `function' is called.
		do
			Result := c_gtk_externals.gtk_signal_connect (c_object, e2c("selection_changed"), function, data)
		end

	connect_select_child_signal (function: POINTER; data: POINTER): INTEGER is
			-- Connect `function' to the "select_child" signal.
			-- `data' will be passed back when `function' is called.
		do
			Result := c_gtk_externals.gtk_signal_connect (c_object, e2c("select_child"), function, data)
		end

	connect_unselect_child_signal (function: POINTER; data: POINTER): INTEGER is
			-- Connect `function' to the "unselect_child" signal.
			-- `data' will be passed back when `function' is called.
		do
			Result := c_gtk_externals.gtk_signal_connect (c_object, e2c("unselect_child"), function, data)
		end

feature -- Implementation

	c_gtk_list: C_GTK_LIST is
		once
			create Result
		end

end -- class GTK_LIST

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)
