indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkTree"
	gtk_file: "gtktree.h"
	status: "See notice at end of class"
	signals: "selection_changed select_child unselect_child "
	events: ""

class
	C_GTK_TREE

feature -- External C functions

	gtk_tree_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_tree_get_type (
			-- );
			--
			-- Original C code from gtktree.h:
			-- GtkType    gtk_tree_get_type           (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_new: POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_tree_new (
			-- );
			--
			-- Original C code from gtktree.h:
			-- GtkWidget* gtk_tree_new                (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_append (a_tree: POINTER; a_tree_item: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_append (
			--     GtkTree *a_tree,
			--     GtkWidget *a_tree_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_append             (GtkTree          *tree,
			-- 				        GtkWidget        *tree_item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_prepend (a_tree: POINTER; a_tree_item: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_prepend (
			--     GtkTree *a_tree,
			--     GtkWidget *a_tree_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_prepend            (GtkTree          *tree,
			-- 				        GtkWidget        *tree_item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_insert (a_tree: POINTER; a_tree_item: POINTER; a_position: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_insert (
			--     GtkTree *a_tree,
			--     GtkWidget *a_tree_item,
			--     gint a_position
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_insert             (GtkTree          *tree,
			-- 				        GtkWidget        *tree_item,
			-- 				        gint              position);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_remove_items (a_tree: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_remove_items (
			--     GtkTree *a_tree,
			--     GList *a_items
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_remove_items       (GtkTree          *tree,
			-- 				        GList            *items);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_clear_items (a_tree: POINTER; a_start: INTEGER; a_end: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_clear_items (
			--     GtkTree *a_tree,
			--     gint a_start,
			--     gint a_end
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_clear_items        (GtkTree          *tree,
			-- 				        gint              start,
			-- 				        gint              end);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_select_item (a_tree: POINTER; a_item: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_select_item (
			--     GtkTree *a_tree,
			--     gint a_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_select_item        (GtkTree          *tree,
			-- 				        gint              item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_unselect_item (a_tree: POINTER; a_item: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_unselect_item (
			--     GtkTree *a_tree,
			--     gint a_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_unselect_item      (GtkTree          *tree,
			-- 				        gint              item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_select_child (a_tree: POINTER; a_tree_item: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_select_child (
			--     GtkTree *a_tree,
			--     GtkWidget *a_tree_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_select_child       (GtkTree          *tree,
			-- 				        GtkWidget        *tree_item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_unselect_child (a_tree: POINTER; a_tree_item: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_unselect_child (
			--     GtkTree *a_tree,
			--     GtkWidget *a_tree_item
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_unselect_child     (GtkTree          *tree,
			-- 				        GtkWidget        *tree_item);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_child_position (a_tree: POINTER; a_child: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_tree_child_position (
			--     GtkTree *a_tree,
			--     GtkWidget *a_child
			-- );
			--
			-- Original C code from gtktree.h:
			-- gint       gtk_tree_child_position     (GtkTree          *tree,
			-- 				        GtkWidget        *child);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_set_selection_mode (a_tree: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_set_selection_mode (
			--     GtkTree *a_tree,
			--     GtkSelectionMode a_mode
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_set_selection_mode (GtkTree          *tree,
			-- 				        GtkSelectionMode  mode);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_set_view_mode (a_tree: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_set_view_mode (
			--     GtkTree *a_tree,
			--     GtkTreeViewMode a_mode
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_set_view_mode      (GtkTree          *tree,
			-- 				        GtkTreeViewMode   mode);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_set_view_lines (a_tree: POINTER; a_flag: INTEGER) is 
			-- Parsed as:
			-- void gtk_tree_set_view_lines (
			--     GtkTree *a_tree,
			--     guint a_flag
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_set_view_lines     (GtkTree          *tree,
			-- 					guint            flag);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_tree_remove_item (a_tree: POINTER; a_child: POINTER) is 
			-- Parsed as:
			-- void gtk_tree_remove_item (
			--     GtkTree *a_tree,
			--     GtkWidget *a_child
			-- );
			--
			-- Original C code from gtktree.h:
			-- void       gtk_tree_remove_item        (GtkTree          *tree,
			-- 				        GtkWidget        *child);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_TREE

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)