indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GTK_EXTERNALS"
	gtk_file: "gtk.h"
	status: "See notice at end of class"
	signals: ""
	events: ""

class
	C_GTK_EXTERNALS

feature -- External C functions

	gtk_identifier_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_identifier_get_type (
			-- );
			--
			-- Original C code from gtktypeutils.h:
			-- GtkType		gtk_identifier_get_type		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_new (a_arg_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkArg* gtk_arg_new (
			--     GtkType a_arg_type
			-- );
			--
			-- Original C code from gtkarg.h:
			-- GtkArg*		gtk_arg_new		 (GtkType	arg_type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_copy (a_src_arg: POINTER; a_dest_arg: POINTER): POINTER is 
			-- Parsed as:
			-- GtkArg* gtk_arg_copy (
			--     GtkArg *a_src_arg,
			--     GtkArg *a_dest_arg
			-- );
			--
			-- Original C code from gtkarg.h:
			-- GtkArg*		gtk_arg_copy		 (GtkArg       *src_arg,
			-- 					  GtkArg       *dest_arg);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_free (a_arg: POINTER; a_free_contents: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_arg_free (
			--     GtkArg *a_arg,
			--     gboolean a_free_contents
			-- );
			--
			-- Original C code from gtkarg.h:
			-- void		gtk_arg_free		 (GtkArg       *arg,
			-- 					  gboolean	free_contents);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_reset (a_arg: POINTER) is 
			-- Parsed as:
			-- void gtk_arg_reset (
			--     GtkArg *a_arg
			-- );
			--
			-- Original C code from gtkarg.h:
			-- void		gtk_arg_reset		 (GtkArg       *arg);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_values_equal (a_arg1: POINTER; a_arg2: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_arg_values_equal (
			--     GtkArg *a_arg1,
			--     GtkArg *a_arg2
			-- );
			--
			-- Original C code from gtkarg.h:
			-- gboolean	gtk_arg_values_equal	 (const GtkArg *arg1,
			-- 					  const GtkArg *arg2);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_args_collect (a_object_type: INTEGER; a_arg_info_hash_table: POINTER; a_arg_list_p: POINTER; a_info_list_p: POINTER; a_first_arg_name: POINTER; a_var_args: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_args_collect (
			--     GtkType a_object_type,
			--     GHashTable *a_arg_info_hash_table,
			--     GSList **a_arg_list_p,
			--     GSList **a_info_list_p,
			--     gchar *a_first_arg_name,
			--     va_list a_var_args
			-- );
			--
			-- Original C code from gtkarg.h:
			-- gchar*		gtk_args_collect	 (GtkType	object_type,
			-- 					  GHashTable    *arg_info_hash_table,
			-- 					  GSList      **arg_list_p,
			-- 					  GSList      **info_list_p,
			-- 					  const gchar   *first_arg_name,
			-- 					  va_list	var_args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_args_collect_cleanup (a_arg_list: POINTER; a_info_list: POINTER) is 
			-- Parsed as:
			-- void gtk_args_collect_cleanup (
			--     GSList *a_arg_list,
			--     GSList *a_info_list
			-- );
			--
			-- Original C code from gtkarg.h:
			-- void		gtk_args_collect_cleanup (GSList       *arg_list,
			-- 					  GSList       *info_list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_get_info (a_object_type: INTEGER; a_arg_info_hash_table: POINTER; a_arg_name: POINTER; a_info_p: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_arg_get_info (
			--     GtkType a_object_type,
			--     GHashTable *a_arg_info_hash_table,
			--     gchar *a_arg_name,
			--     GtkArgInfo **a_info_p
			-- );
			--
			-- Original C code from gtkarg.h:
			-- gchar*		gtk_arg_get_info	 (GtkType	object_type,
			-- 					  GHashTable    *arg_info_hash_table,
			-- 					  const gchar   *arg_name,
			-- 					  GtkArgInfo   **info_p);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_type_new_static (a_base_class_type: INTEGER; a_arg_name: POINTER; a_class_n_args_offset: INTEGER; a_arg_info_hash_table: POINTER; a_arg_type: INTEGER; a_arg_flags: INTEGER; a_arg_id: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkArgInfo* gtk_arg_type_new_static (
			--     GtkType a_base_class_type,
			--     gchar *a_arg_name,
			--     guint a_class_n_args_offset,
			--     GHashTable *a_arg_info_hash_table,
			--     GtkType a_arg_type,
			--     guint a_arg_flags,
			--     guint a_arg_id
			-- );
			--
			-- Original C code from gtkarg.h:
			-- GtkArgInfo*	gtk_arg_type_new_static	 (GtkType	base_class_type,
			-- 					  const gchar   *arg_name,
			-- 					  guint		class_n_args_offset,
			-- 					  GHashTable    *arg_info_hash_table,
			-- 					  GtkType	arg_type,
			-- 					  guint		arg_flags,
			-- 					  guint		arg_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_args_query (a_class_type: INTEGER; a_arg_info_hash_table: POINTER; a_arg_flags: POINTER; a_n_args_p: POINTER): POINTER is 
			-- Parsed as:
			-- GtkArg* gtk_args_query (
			--     GtkType a_class_type,
			--     GHashTable *a_arg_info_hash_table,
			--     guint32 **a_arg_flags,
			--     guint *a_n_args_p
			-- );
			--
			-- Original C code from gtkarg.h:
			-- GtkArg*		gtk_args_query		 (GtkType	class_type,
			-- 					  GHashTable    *arg_info_hash_table,
			-- 					  guint32      **arg_flags,
			-- 					  guint	       *n_args_p);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_name_strip_type (a_arg_name: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_arg_name_strip_type (
			--     gchar *a_arg_name
			-- );
			--
			-- Original C code from gtkarg.h:
			-- gchar*		gtk_arg_name_strip_type	 (const gchar   *arg_name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_info_equal (a_arg_info_1: POINTER; a_arg_info_2: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_arg_info_equal (
			--     gconstpointer a_arg_info_1,
			--     gconstpointer a_arg_info_2
			-- );
			--
			-- Original C code from gtkarg.h:
			-- gint		gtk_arg_info_equal	 (gconstpointer	 arg_info_1,
			-- 					  gconstpointer	 arg_info_2);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_info_hash (a_arg_info: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_arg_info_hash (
			--     gconstpointer a_arg_info
			-- );
			--
			-- Original C code from gtkarg.h:
			-- guint		gtk_arg_info_hash	 (gconstpointer	 arg_info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_arg_to_valueloc (a_arg: POINTER; a_value_pointer: POINTER) is 
			-- Parsed as:
			-- void gtk_arg_to_valueloc (
			--     GtkArg *a_arg,
			--     gpointer a_value_pointer
			-- );
			--
			-- Original C code from gtkarg.h:
			-- void		gtk_arg_to_valueloc	 (GtkArg	*arg,
			-- 					  gpointer	 value_pointer);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_trace_referencing (a_object: POINTER; a_func: POINTER; a_dummy: INTEGER; a_line: INTEGER; a_do_ref: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_trace_referencing (
			--     GtkObject *a_object,
			--     gchar *a_func,
			--     guint a_dummy,
			--     guint a_line,
			--     gboolean a_do_ref
			-- );
			--
			-- Original C code from gtkobject.h:
			-- void	gtk_trace_referencing	(GtkObject   *object,
			-- 				 const gchar *func,
			-- 				 guint	      dummy,
			-- 				 guint	      line,
			-- 				 gboolean     do_ref);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_new: POINTER is 
			-- Parsed as:
			-- GtkAccelGroup* gtk_accel_group_new (
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GtkAccelGroup*  gtk_accel_group_new	      	(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_get_default: POINTER is 
			-- Parsed as:
			-- GtkAccelGroup* gtk_accel_group_get_default (
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GtkAccelGroup*  gtk_accel_group_get_default    	(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_ref (a_accel_group: POINTER): POINTER is 
			-- Parsed as:
			-- GtkAccelGroup* gtk_accel_group_ref (
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GtkAccelGroup*  gtk_accel_group_ref	     	(GtkAccelGroup	*accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_unref (a_accel_group: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_unref (
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void	        gtk_accel_group_unref	      	(GtkAccelGroup	*accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_activate (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_accel_group_activate (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- gboolean        gtk_accel_group_activate	(GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_groups_activate (a_object: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_accel_groups_activate (
			--     GtkObject *a_object,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- gboolean        gtk_accel_groups_activate      	(GtkObject	*object,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_attach (a_accel_group: POINTER; a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_attach (
			--     GtkAccelGroup *a_accel_group,
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_attach		(GtkAccelGroup	*accel_group,
			-- 						 GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_detach (a_accel_group: POINTER; a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_detach (
			--     GtkAccelGroup *a_accel_group,
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_detach		(GtkAccelGroup	*accel_group,
			-- 						 GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_lock (a_accel_group: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_lock (
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_lock		(GtkAccelGroup	*accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_unlock (a_accel_group: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_unlock (
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_unlock		(GtkAccelGroup	*accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_get_entry (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkAccelEntry* gtk_accel_group_get_entry (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GtkAccelEntry* 	gtk_accel_group_get_entry      	(GtkAccelGroup  *accel_group,
			-- 						 guint           accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_lock_entry (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER) is 
			-- Parsed as:
			-- void gtk_accel_group_lock_entry (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_lock_entry	(GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_unlock_entry (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER) is 
			-- Parsed as:
			-- void gtk_accel_group_unlock_entry (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_unlock_entry	(GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_add (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER; a_accel_flags: INTEGER; a_object: POINTER; a_accel_signal: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_add (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods,
			--     GtkAccelFlags a_accel_flags,
			--     GtkObject *a_object,
			--     gchar *a_accel_signal
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_add		(GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods,
			-- 						 GtkAccelFlags	 accel_flags,
			-- 						 GtkObject	*object,
			-- 						 const gchar	*accel_signal);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_remove (a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER; a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_remove (
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods,
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_remove		(GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods,
			-- 						 GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_handle_add (a_object: POINTER; a_accel_signal_id: INTEGER; a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER; a_accel_flags: INTEGER) is 
			-- Parsed as:
			-- void gtk_accel_group_handle_add (
			--     GtkObject *a_object,
			--     guint a_accel_signal_id,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods,
			--     GtkAccelFlags a_accel_flags
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_handle_add	(GtkObject	*object,
			-- 						 guint		 accel_signal_id,
			-- 						 GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods,
			-- 						 GtkAccelFlags   accel_flags);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_handle_remove (a_object: POINTER; a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER) is 
			-- Parsed as:
			-- void gtk_accel_group_handle_remove (
			--     GtkObject *a_object,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     GdkModifierType a_accel_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_handle_remove	(GtkObject	*object,
			-- 						 GtkAccelGroup	*accel_group,
			-- 						 guint		 accel_key,
			-- 						 GdkModifierType accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_create_add (a_class_type: INTEGER; a_signal_flags: INTEGER; a_handler_offset: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_accel_group_create_add (
			--     GtkType a_class_type,
			--     GtkSignalRunType a_signal_flags,
			--     guint a_handler_offset
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- guint		gtk_accel_group_create_add	(GtkType	 class_type,
			-- 						 GtkSignalRunType signal_flags,
			-- 						 guint		 handler_offset);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_create_remove (a_class_type: INTEGER; a_signal_flags: INTEGER; a_handler_offset: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_accel_group_create_remove (
			--     GtkType a_class_type,
			--     GtkSignalRunType a_signal_flags,
			--     guint a_handler_offset
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- guint		gtk_accel_group_create_remove	(GtkType	 class_type,
			-- 						 GtkSignalRunType signal_flags,
			-- 						 guint		 handler_offset);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_marshal_add (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_marshal_add (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_marshal_add	(GtkObject	*object,
			-- 						 GtkSignalFunc	 func,
			-- 						 gpointer	 func_data,
			-- 						 GtkArg		*args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_marshal_remove (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_accel_group_marshal_remove (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void		gtk_accel_group_marshal_remove	(GtkObject	*object,
			-- 						 GtkSignalFunc	 func,
			-- 						 gpointer	 func_data,
			-- 						 GtkArg		*args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_groups_from_object (a_object: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* gtk_accel_groups_from_object (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GSList*	gtk_accel_groups_from_object		(GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accel_group_entries_from_object (a_object: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* gtk_accel_group_entries_from_object (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- GSList*	gtk_accel_group_entries_from_object	(GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accelerator_valid (a_keyval: INTEGER; a_modifiers: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_accelerator_valid (
			--     guint a_keyval,
			--     GdkModifierType a_modifiers
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- gboolean gtk_accelerator_valid		      (guint	        keyval,
			-- 					       GdkModifierType  modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accelerator_parse (a_accelerator: POINTER; a_accelerator_key: POINTER; a_accelerator_mods: POINTER) is 
			-- Parsed as:
			-- void gtk_accelerator_parse (
			--     gchar *a_accelerator,
			--     guint *a_accelerator_key,
			--     GdkModifierType *a_accelerator_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void	 gtk_accelerator_parse		      (const gchar     *accelerator,
			-- 					       guint	       *accelerator_key,
			-- 					       GdkModifierType *accelerator_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accelerator_name (a_accelerator_key: INTEGER; a_accelerator_mods: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_accelerator_name (
			--     guint a_accelerator_key,
			--     GdkModifierType a_accelerator_mods
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- gchar*	 gtk_accelerator_name		      (guint	        accelerator_key,
			-- 					       GdkModifierType  accelerator_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accelerator_set_default_mod_mask (a_default_mod_mask: INTEGER) is 
			-- Parsed as:
			-- void gtk_accelerator_set_default_mod_mask (
			--     GdkModifierType a_default_mod_mask
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- void	 gtk_accelerator_set_default_mod_mask (GdkModifierType  default_mod_mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_accelerator_get_default_mod_mask: INTEGER is 
			-- Parsed as:
			-- guint gtk_accelerator_get_default_mod_mask (
			-- );
			--
			-- Original C code from gtkaccelgroup.h:
			-- guint	 gtk_accelerator_get_default_mod_mask (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_hline (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_x1: INTEGER; a_x2: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_hline (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     gint a_x1,
			--     gint a_x2,
			--     gint a_y
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_hline   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       gint	      x1,
			-- 		       gint	      x2,
			-- 		       gint	      y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_vline (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_y1: INTEGER; a_y2: INTEGER; a_x: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_vline (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     gint a_y1,
			--     gint a_y2,
			--     gint a_x
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_vline   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       gint	      y1,
			-- 		       gint	      y2,
			-- 		       gint	      x);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_shadow (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_shadow (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_shadow  (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_polygon (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_points: POINTER; a_npoints: INTEGER; a_fill: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_draw_polygon (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkPoint *a_points,
			--     gint a_npoints,
			--     gboolean a_fill
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_polygon (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       GdkPoint	     *points,
			-- 		       gint	      npoints,
			-- 		       gboolean	      fill);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_arrow (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_arrow_type: INTEGER; a_fill: BOOLEAN; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_arrow (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GtkArrowType a_arrow_type,
			--     gboolean a_fill,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_arrow   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       GtkArrowType   arrow_type,
			-- 		       gboolean	      fill,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_diamond (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_diamond (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_diamond (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_oval (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_oval (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_oval    (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_string (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_string: POINTER) is 
			-- Parsed as:
			-- void gtk_draw_string (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     gint a_x,
			--     gint a_y,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_string  (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       const gchar   *string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_box (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_box (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_box     (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_flat_box (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_flat_box (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_flat_box (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_check (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_check (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_check   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_option (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_option (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_option  (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_cross (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_cross (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_cross   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_ramp (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_arrow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_ramp (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GtkArrowType a_arrow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_ramp    (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       GtkArrowType   arrow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_tab (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_tab (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_tab     (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_shadow_gap (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER; a_gap_x: INTEGER; a_gap_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_shadow_gap (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side,
			--     gint a_gap_x,
			--     gint a_gap_width
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_shadow_gap (GtkStyle	 *style,
			-- 			  GdkWindow	 *window,
			-- 			  GtkStateType	  state_type,
			-- 			  GtkShadowType	  shadow_type,
			-- 			  gint		  x,
			-- 			  gint		  y,
			-- 			  gint		  width,
			-- 			  gint		  height,
			-- 			  GtkPositionType gap_side,
			-- 			  gint		  gap_x,
			-- 			  gint		  gap_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_box_gap (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER; a_gap_x: INTEGER; a_gap_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_box_gap (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side,
			--     gint a_gap_x,
			--     gint a_gap_width
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_box_gap (GtkStyle	      *style,
			-- 		       GdkWindow      *window,
			-- 		       GtkStateType    state_type,
			-- 		       GtkShadowType   shadow_type,
			-- 		       gint	       x,
			-- 		       gint	       y,
			-- 		       gint	       width,
			-- 		       gint	       height,
			-- 		       GtkPositionType gap_side,
			-- 		       gint	       gap_x,
			-- 		       gint	       gap_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_extension (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_extension (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_extension (GtkStyle	*style,
			-- 			 GdkWindow	*window,
			-- 			 GtkStateType	 state_type,
			-- 			 GtkShadowType	 shadow_type,
			-- 			 gint		 x,
			-- 			 gint		 y,
			-- 			 gint		 width,
			-- 			 gint		 height,
			-- 			 GtkPositionType gap_side);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_focus (a_style: POINTER; a_window: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_focus (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_focus   (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_slider (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_orientation: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_slider (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkOrientation a_orientation
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_slider  (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height,
			-- 		       GtkOrientation orientation);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_draw_handle (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_orientation: INTEGER) is 
			-- Parsed as:
			-- void gtk_draw_handle (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkOrientation a_orientation
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_draw_handle  (GtkStyle	     *style,
			-- 		       GdkWindow     *window,
			-- 		       GtkStateType   state_type,
			-- 		       GtkShadowType  shadow_type,
			-- 		       gint	      x,
			-- 		       gint	      y,
			-- 		       gint	      width,
			-- 		       gint	      height,
			-- 		       GtkOrientation orientation);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_hline (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x1: INTEGER; a_x2: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_hline (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x1,
			--     gint a_x2,
			--     gint a_y
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_hline   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x1,
			-- 			gint	       x2,
			-- 			gint	       y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_vline (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_y1: INTEGER; a_y2: INTEGER; a_x: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_vline (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_y1,
			--     gint a_y2,
			--     gint a_x
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_vline   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       y1,
			-- 			gint	       y2,
			-- 			gint	       x);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_shadow (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_shadow (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_shadow  (GtkStyle     *style,
			-- 			GdkWindow    *window,
			-- 			GtkStateType  state_type,
			-- 			GtkShadowType shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_polygon (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_points: POINTER; a_npoints: INTEGER; a_fill: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_paint_polygon (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     GdkPoint *a_points,
			--     gint a_npoints,
			--     gboolean a_fill
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_polygon (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			GdkPoint      *points,
			-- 			gint	       npoints,
			-- 			gboolean       fill);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_arrow (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_arrow_type: INTEGER; a_fill: BOOLEAN; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_arrow (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     GtkArrowType a_arrow_type,
			--     gboolean a_fill,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_arrow   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			GtkArrowType   arrow_type,
			-- 			gboolean       fill,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_diamond (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_diamond (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_diamond (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_oval (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_oval (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_oval    (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_string (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_string: POINTER) is 
			-- Parsed as:
			-- void gtk_paint_string (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_string  (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			const gchar   *string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_box (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_box (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_box     (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_flat_box (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_flat_box (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_flat_box (GtkStyle      *style,
			-- 			 GdkWindow     *window,
			-- 			 GtkStateType	state_type,
			-- 			 GtkShadowType	shadow_type,
			-- 			 GdkRectangle  *area,
			-- 			 GtkWidget     *widget,
			-- 			 gchar	       *detail,
			-- 			 gint		x,
			-- 			 gint		y,
			-- 			 gint		width,
			-- 			 gint		height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_check (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_check (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_check   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_option (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_option (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_option  (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_cross (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_cross (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_cross   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_ramp (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_arrow_type: INTEGER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_ramp (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     GtkArrowType a_arrow_type,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_ramp    (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			GtkArrowType   arrow_type,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_tab (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_tab (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_tab     (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_shadow_gap (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER; a_gap_x: INTEGER; a_gap_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_shadow_gap (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side,
			--     gint a_gap_x,
			--     gint a_gap_width
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_shadow_gap (GtkStyle	  *style,
			-- 			   GdkWindow	  *window,
			-- 			   GtkStateType	   state_type,
			-- 			   GtkShadowType   shadow_type,
			-- 			   GdkRectangle	  *area,
			-- 			   GtkWidget	  *widget,
			-- 			   gchar	  *detail,
			-- 			   gint		   x,
			-- 			   gint		   y,
			-- 			   gint		   width,
			-- 			   gint		   height,
			-- 			   GtkPositionType gap_side,
			-- 			   gint		   gap_x,
			-- 			   gint		   gap_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_box_gap (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER; a_gap_x: INTEGER; a_gap_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_box_gap (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side,
			--     gint a_gap_x,
			--     gint a_gap_width
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_box_gap (GtkStyle       *style,
			-- 			GdkWindow      *window,
			-- 			GtkStateType	state_type,
			-- 			GtkShadowType	shadow_type,
			-- 			GdkRectangle   *area,
			-- 			GtkWidget      *widget,
			-- 			gchar	       *detail,
			-- 			gint		x,
			-- 			gint		y,
			-- 			gint		width,
			-- 			gint		height,
			-- 			GtkPositionType gap_side,
			-- 			gint		gap_x,
			-- 			gint		gap_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_extension (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_gap_side: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_extension (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkPositionType a_gap_side
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_extension (GtkStyle	 *style,
			-- 			  GdkWindow	 *window,
			-- 			  GtkStateType	  state_type,
			-- 			  GtkShadowType	  shadow_type,
			-- 			  GdkRectangle	 *area,
			-- 			  GtkWidget	 *widget,
			-- 			  gchar		 *detail,
			-- 			  gint		  x,
			-- 			  gint		  y,
			-- 			  gint		  width,
			-- 			  gint		  height,
			-- 			  GtkPositionType gap_side);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_focus (a_style: POINTER; a_window: POINTER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_focus (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_focus   (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_slider (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_orientation: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_slider (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkOrientation a_orientation
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_slider  (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height,
			-- 			GtkOrientation orientation);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_paint_handle (a_style: POINTER; a_window: POINTER; a_state_type: INTEGER; a_shadow_type: INTEGER; a_area: POINTER; a_widget: POINTER; a_detail: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER; a_orientation: INTEGER) is 
			-- Parsed as:
			-- void gtk_paint_handle (
			--     GtkStyle *a_style,
			--     GdkWindow *a_window,
			--     GtkStateType a_state_type,
			--     GtkShadowType a_shadow_type,
			--     GdkRectangle *a_area,
			--     GtkWidget *a_widget,
			--     gchar *a_detail,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height,
			--     GtkOrientation a_orientation
			-- );
			--
			-- Original C code from gtkstyle.h:
			-- void gtk_paint_handle  (GtkStyle      *style,
			-- 			GdkWindow     *window,
			-- 			GtkStateType   state_type,
			-- 			GtkShadowType  shadow_type,
			-- 			GdkRectangle  *area,
			-- 			GtkWidget     *widget,
			-- 			gchar	      *detail,
			-- 			gint	       x,
			-- 			gint	       y,
			-- 			gint	       width,
			-- 			gint	       height,
			-- 			GtkOrientation orientation);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_pattern_spec_init (a_pspec: POINTER; a_pattern: POINTER) is 
			-- Parsed as:
			-- void gtk_pattern_spec_init (
			--     GtkPatternSpec *a_pspec,
			--     gchar *a_pattern
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_pattern_spec_init	    (GtkPatternSpec	 *pspec,
			-- 				     const gchar	 *pattern);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_pattern_spec_free_segs (a_pspec: POINTER) is 
			-- Parsed as:
			-- void gtk_pattern_spec_free_segs (
			--     GtkPatternSpec *a_pspec
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_pattern_spec_free_segs (GtkPatternSpec	 *pspec);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_pattern_match (a_pspec: POINTER; a_string_length: INTEGER; a_string: POINTER; a_string_reversed: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_pattern_match (
			--     GtkPatternSpec *a_pspec,
			--     guint a_string_length,
			--     gchar *a_string,
			--     gchar *a_string_reversed
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- gboolean gtk_pattern_match	    (GtkPatternSpec	 *pspec,
			-- 				     guint		  string_length,
			-- 				     const gchar	 *string,
			-- 				     const gchar	 *string_reversed);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_pattern_match_string (a_pspec: POINTER; a_string: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_pattern_match_string (
			--     GtkPatternSpec *a_pspec,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- gboolean gtk_pattern_match_string   (GtkPatternSpec	 *pspec,
			-- 				     const gchar	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_pattern_match_simple (a_pattern: POINTER; a_string: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_pattern_match_simple (
			--     gchar *a_pattern,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- gboolean gtk_pattern_match_simple   (const gchar	 *pattern,
			-- 				     const gchar	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_set_new (a_set_name: POINTER): POINTER is 
			-- Parsed as:
			-- GtkBindingSet* gtk_binding_set_new (
			--     gchar *a_set_name
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- GtkBindingSet*	gtk_binding_set_new	(const gchar	*set_name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_set_by_class (a_object_class: POINTER): POINTER is 
			-- Parsed as:
			-- GtkBindingSet* gtk_binding_set_by_class (
			--     gpointer a_object_class
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- GtkBindingSet*	gtk_binding_set_by_class(gpointer	 object_class);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_set_find (a_set_name: POINTER): POINTER is 
			-- Parsed as:
			-- GtkBindingSet* gtk_binding_set_find (
			--     gchar *a_set_name
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- GtkBindingSet*	gtk_binding_set_find	(const gchar	*set_name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_bindings_activate (a_object: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_bindings_activate (
			--     GtkObject *a_object,
			--     guint a_keyval,
			--     guint a_modifiers
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- gboolean gtk_bindings_activate		(GtkObject	*object,
			-- 					 guint		 keyval,
			-- 					 guint		 modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_set_activate (a_binding_set: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER; a_object: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_binding_set_activate (
			--     GtkBindingSet *a_binding_set,
			--     guint a_keyval,
			--     guint a_modifiers,
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- gboolean gtk_binding_set_activate	(GtkBindingSet	*binding_set,
			-- 					 guint		 keyval,
			-- 					 guint		 modifiers,
			-- 					 GtkObject	*object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_entry_clear (a_binding_set: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER) is 
			-- Parsed as:
			-- void gtk_binding_entry_clear (
			--     GtkBindingSet *a_binding_set,
			--     guint a_keyval,
			--     guint a_modifiers
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_binding_entry_clear	(GtkBindingSet	*binding_set,
			-- 					 guint		 keyval,
			-- 					 guint		 modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_set_add_path (a_binding_set: POINTER; a_path_type: INTEGER; a_path_pattern: POINTER; a_priority: INTEGER) is 
			-- Parsed as:
			-- void gtk_binding_set_add_path (
			--     GtkBindingSet *a_binding_set,
			--     GtkPathType a_path_type,
			--     gchar *a_path_pattern,
			--     GtkPathPriorityType a_priority
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_binding_set_add_path	(GtkBindingSet	*binding_set,
			-- 					 GtkPathType	 path_type,
			-- 					 const gchar	*path_pattern,
			-- 					 GtkPathPriorityType priority);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_entry_remove (a_binding_set: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER) is 
			-- Parsed as:
			-- void gtk_binding_entry_remove (
			--     GtkBindingSet *a_binding_set,
			--     guint a_keyval,
			--     guint a_modifiers
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_binding_entry_remove	(GtkBindingSet	*binding_set,
			-- 					 guint		 keyval,
			-- 					 guint		 modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_entry_add_signall (a_binding_set: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER; a_signal_name: POINTER; a_binding_args: POINTER) is 
			-- Parsed as:
			-- void gtk_binding_entry_add_signall (
			--     GtkBindingSet *a_binding_set,
			--     guint a_keyval,
			--     guint a_modifiers,
			--     gchar *a_signal_name,
			--     GSList *a_binding_args
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- void	 gtk_binding_entry_add_signall	(GtkBindingSet	*binding_set,
			-- 					 guint		 keyval,
			-- 					 guint		 modifiers,
			-- 					 const gchar	*signal_name,
			-- 					 GSList		*binding_args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_binding_parse_binding (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_binding_parse_binding (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from gtkbindings.h:
			-- guint	 gtk_binding_parse_binding	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__NONE (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__NONE (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__NONE (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__POINTER_POINTER_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__POINTER_POINTER_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__POINTER_POINTER_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__POINTER_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__POINTER_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__POINTER_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__POINTER_INT_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__POINTER_INT_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__POINTER_INT_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_INT__INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_INT__INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_INT__INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_INT__POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_INT__POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_INT__POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_INT__POINTER_CHAR_CHAR (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_INT__POINTER_CHAR_CHAR (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_INT__POINTER_CHAR_CHAR (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__BOOL (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__BOOL (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__BOOL (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__C_CALLBACK (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__C_CALLBACK (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__C_CALLBACK (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__C_CALLBACK_C_CALLBACK (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__C_CALLBACK_C_CALLBACK (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__C_CALLBACK_C_CALLBACK (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_FLOAT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_FLOAT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_FLOAT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_FLOAT_BOOL (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_FLOAT_BOOL (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_FLOAT_BOOL (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_INT_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_INT_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_INT_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__NONE (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__NONE (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__NONE (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_POINTER_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_POINTER_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_POINTER_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_POINTER_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_POINTER_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_POINTER_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__POINTER_INT_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__POINTER_INT_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__POINTER_INT_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_POINTER_INT_INT_INT (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_POINTER_INT_INT_INT (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_POINTER_INT_INT_INT (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_marshal_NONE__INT_POINTER (a_object: POINTER; a_func: POINTER; a_func_data: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_marshal_NONE__INT_POINTER (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkmarshal.h:
			-- void gtk_marshal_NONE__INT_POINTER (GtkObject    *object, 
			--                             GtkSignalFunc func, 
			--                             gpointer      func_data, 
			--                             GtkArg       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_lookup (a_name: POINTER; a_object_type: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_lookup (
			--     gchar *a_name,
			--     GtkType a_object_type
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_lookup		  (const gchar	       *name,
			-- 					   GtkType		object_type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_name (a_signal_id: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_signal_name (
			--     guint a_signal_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- gchar* gtk_signal_name			  (guint		signal_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_n_emissions (a_object: POINTER; a_signal_id: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_n_emissions (
			--     GtkObject *a_object,
			--     guint a_signal_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_n_emissions		  (GtkObject   	       *object,
			-- 					   guint                signal_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_n_emissions_by_name (a_object: POINTER; a_name: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_n_emissions_by_name (
			--     GtkObject *a_object,
			--     gchar *a_name
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_n_emissions_by_name	  (GtkObject   	       *object,
			-- 					   const gchar         *name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_emit_stop (a_object: POINTER; a_signal_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_signal_emit_stop (
			--     GtkObject *a_object,
			--     guint a_signal_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_emit_stop		  (GtkObject	       *object,
			-- 					   guint		signal_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_emit_stop_by_name (a_object: POINTER; a_name: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_emit_stop_by_name (
			--     GtkObject *a_object,
			--     gchar *a_name
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_emit_stop_by_name	  (GtkObject	       *object,
			-- 					   const gchar	       *name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect (a_object: POINTER; a_name: POINTER; a_func: POINTER; a_func_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_connect (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_connect		  (GtkObject	       *object,
			-- 					   const gchar	       *name,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		func_data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_after (a_object: POINTER; a_name: POINTER; a_func: POINTER; a_func_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_connect_after (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_connect_after		  (GtkObject	       *object,
			-- 					   const gchar	       *name,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		func_data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_object (a_object: POINTER; a_name: POINTER; a_func: POINTER; a_slot_object: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_connect_object (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkSignalFunc a_func,
			--     GtkObject *a_slot_object
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_connect_object	  (GtkObject	       *object,
			-- 					   const gchar	       *name,
			-- 					   GtkSignalFunc	func,
			-- 					   GtkObject	       *slot_object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_object_after (a_object: POINTER; a_name: POINTER; a_func: POINTER; a_slot_object: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_connect_object_after (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkSignalFunc a_func,
			--     GtkObject *a_slot_object
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_connect_object_after	  (GtkObject	       *object,
			-- 					   const gchar	       *name,
			-- 					   GtkSignalFunc	func,
			-- 					   GtkObject	       *slot_object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_full (a_object: POINTER; a_name: POINTER; a_func: POINTER; a_marshal: POINTER; a_data: POINTER; a_destroy_func: POINTER; a_object_signal: INTEGER; a_after: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_connect_full (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkSignalFunc a_func,
			--     GtkCallbackMarshal a_marshal,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy_func,
			--     gint a_object_signal,
			--     gint a_after
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_connect_full		  (GtkObject	       *object,
			-- 					   const gchar	       *name,
			-- 					   GtkSignalFunc	func,
			-- 					   GtkCallbackMarshal	marshal,
			-- 					   gpointer		data,
			-- 					   GtkDestroyNotify	destroy_func,
			-- 					   gint			object_signal,
			-- 					   gint			after);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_object_while_alive (a_object: POINTER; a_signal: POINTER; a_func: POINTER; a_alive_object: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_connect_object_while_alive (
			--     GtkObject *a_object,
			--     gchar *a_signal,
			--     GtkSignalFunc a_func,
			--     GtkObject *a_alive_object
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_connect_object_while_alive (GtkObject	       *object,
			-- 					      const gchar      *signal,
			-- 					      GtkSignalFunc	func,
			-- 					      GtkObject	       *alive_object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_connect_while_alive (a_object: POINTER; a_signal: POINTER; a_func: POINTER; a_func_data: POINTER; a_alive_object: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_connect_while_alive (
			--     GtkObject *a_object,
			--     gchar *a_signal,
			--     GtkSignalFunc a_func,
			--     gpointer a_func_data,
			--     GtkObject *a_alive_object
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_connect_while_alive	     (GtkObject	       *object,
			-- 					      const gchar      *signal,
			-- 					      GtkSignalFunc	func,
			-- 					      gpointer		func_data,
			-- 					      GtkObject	       *alive_object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_disconnect (a_object: POINTER; a_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_signal_disconnect (
			--     GtkObject *a_object,
			--     guint a_handler_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_disconnect		  (GtkObject	       *object,
			-- 					   guint		handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_disconnect_by_func (a_object: POINTER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_disconnect_by_func (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_disconnect_by_func	  (GtkObject	       *object,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_disconnect_by_data (a_object: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_disconnect_by_data (
			--     GtkObject *a_object,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_disconnect_by_data	  (GtkObject	       *object,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_block (a_object: POINTER; a_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_signal_handler_block (
			--     GtkObject *a_object,
			--     guint a_handler_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_block		  (GtkObject	       *object,
			-- 					   guint		handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_block_by_func (a_object: POINTER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_handler_block_by_func (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_block_by_func	  (GtkObject	       *object,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_block_by_data (a_object: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_handler_block_by_data (
			--     GtkObject *a_object,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_block_by_data	  (GtkObject	       *object,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_unblock (a_object: POINTER; a_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_signal_handler_unblock (
			--     GtkObject *a_object,
			--     guint a_handler_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_unblock	  (GtkObject	       *object,
			-- 					   guint		handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_unblock_by_func (a_object: POINTER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_handler_unblock_by_func (
			--     GtkObject *a_object,
			--     GtkSignalFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_unblock_by_func (GtkObject	       *object,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_unblock_by_data (a_object: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_handler_unblock_by_data (
			--     GtkObject *a_object,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handler_unblock_by_data (GtkObject	       *object,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_pending (a_object: POINTER; a_signal_id: INTEGER; a_may_be_blocked: BOOLEAN): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_handler_pending (
			--     GtkObject *a_object,
			--     guint a_signal_id,
			--     gboolean a_may_be_blocked
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_handler_pending	  (GtkObject	       *object,
			-- 					   guint		signal_id,
			-- 					   gboolean		may_be_blocked);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_pending_by_func (a_object: POINTER; a_signal_id: INTEGER; a_may_be_blocked: BOOLEAN; a_func: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_handler_pending_by_func (
			--     GtkObject *a_object,
			--     guint a_signal_id,
			--     gboolean a_may_be_blocked,
			--     GtkSignalFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_handler_pending_by_func (GtkObject	       *object,
			-- 					   guint		signal_id,
			-- 					   gboolean		may_be_blocked,
			-- 					   GtkSignalFunc	func,
			-- 					   gpointer		data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handler_pending_by_id (a_object: POINTER; a_handler_id: INTEGER; a_may_be_blocked: BOOLEAN): INTEGER is 
			-- Parsed as:
			-- gint gtk_signal_handler_pending_by_id (
			--     GtkObject *a_object,
			--     guint a_handler_id,
			--     gboolean a_may_be_blocked
			-- );
			--
			-- Original C code from gtksignal.h:
			-- gint   gtk_signal_handler_pending_by_id   (GtkObject	       *object,
			-- 					   guint		handler_id,
			-- 					   gboolean		may_be_blocked);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_add_emission_hook (a_signal_id: INTEGER; a_hook_func: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_add_emission_hook (
			--     guint a_signal_id,
			--     GtkEmissionHook a_hook_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_add_emission_hook	  (guint		signal_id,
			-- 					   GtkEmissionHook	hook_func,
			-- 					   gpointer       	data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_add_emission_hook_full (a_signal_id: INTEGER; a_hook_func: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_add_emission_hook_full (
			--     guint a_signal_id,
			--     GtkEmissionHook a_hook_func,
			--     gpointer a_data,
			--     GDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_add_emission_hook_full  (guint		signal_id,
			-- 					   GtkEmissionHook	hook_func,
			-- 					   gpointer       	data,
			-- 					   GDestroyNotify	destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_remove_emission_hook (a_signal_id: INTEGER; a_hook_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_signal_remove_emission_hook (
			--     guint a_signal_id,
			--     guint a_hook_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_remove_emission_hook	  (guint		signal_id,
			-- 					   guint		hook_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_query (a_signal_id: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkSignalQuery* gtk_signal_query (
			--     guint a_signal_id
			-- );
			--
			-- Original C code from gtksignal.h:
			-- GtkSignalQuery* gtk_signal_query	  (guint		signal_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_init is 
			-- Parsed as:
			-- void gtk_signal_init (
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_init			  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_newv (a_name: POINTER; a_signal_flags: INTEGER; a_object_type: INTEGER; a_function_offset: INTEGER; a_marshaller: POINTER; a_return_val: INTEGER; a_nparams: INTEGER; a_params: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_signal_newv (
			--     gchar *a_name,
			--     GtkSignalRunType a_signal_flags,
			--     GtkType a_object_type,
			--     guint a_function_offset,
			--     GtkSignalMarshaller a_marshaller,
			--     GtkType a_return_val,
			--     guint a_nparams,
			--     GtkType *a_params
			-- );
			--
			-- Original C code from gtksignal.h:
			-- guint  gtk_signal_newv			  (const gchar	       *name,
			-- 					   GtkSignalRunType	signal_flags,
			-- 					   GtkType		object_type,
			-- 					   guint		function_offset,
			-- 					   GtkSignalMarshaller	marshaller,
			-- 					   GtkType		return_val,
			-- 					   guint		nparams,
			-- 					   GtkType	       *params);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_emitv (a_object: POINTER; a_signal_id: INTEGER; a_params: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_emitv (
			--     GtkObject *a_object,
			--     guint a_signal_id,
			--     GtkArg *a_params
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_emitv			  (GtkObject           *object,
			-- 					   guint                signal_id,
			-- 					   GtkArg              *params);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_emitv_by_name (a_object: POINTER; a_name: POINTER; a_params: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_emitv_by_name (
			--     GtkObject *a_object,
			--     gchar *a_name,
			--     GtkArg *a_params
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_emitv_by_name		  (GtkObject           *object,
			-- 					   const gchar	       *name,
			-- 					   GtkArg              *params);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_handlers_destroy (a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_handlers_destroy (
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_handlers_destroy	  (GtkObject	       *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_signal_set_funcs (a_marshal_func: POINTER; a_destroy_func: POINTER) is 
			-- Parsed as:
			-- void gtk_signal_set_funcs (
			--     GtkSignalMarshal a_marshal_func,
			--     GtkSignalDestroy a_destroy_func
			-- );
			--
			-- Original C code from gtksignal.h:
			-- void   gtk_signal_set_funcs		  (GtkSignalMarshal	marshal_func,
			-- 					   GtkSignalDestroy	destroy_func);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_check_version (a_required_major: INTEGER; a_required_minor: INTEGER; a_required_micro: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_check_version (
			--     guint a_required_major,
			--     guint a_required_minor,
			--     guint a_required_micro
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gchar* gtk_check_version (guint	required_major,
			-- 			  guint	required_minor,
			-- 			  guint	required_micro);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_init (a_argc: POINTER; a_argv: POINTER) is 
			-- Parsed as:
			-- void gtk_init (
			--     int *a_argc,
			--     char ***a_argv
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_init		 (int	       *argc,
			-- 				  char	     ***argv);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_init_check (a_argc: POINTER; a_argv: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_init_check (
			--     int *a_argc,
			--     char ***a_argv
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gboolean   gtk_init_check        (int	       *argc,
			-- 				  char	     ***argv);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_exit (a_error_code: INTEGER) is 
			-- Parsed as:
			-- void gtk_exit (
			--     gint a_error_code
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_exit		 (gint		error_code);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_set_locale: POINTER is 
			-- Parsed as:
			-- gchar* gtk_set_locale (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gchar*	   gtk_set_locale	 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_events_pending: INTEGER is 
			-- Parsed as:
			-- gint gtk_events_pending (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gint	   gtk_events_pending	 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main_do_event (a_event: POINTER) is 
			-- Parsed as:
			-- void gtk_main_do_event (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void  gtk_main_do_event          (GdkEvent           *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main is 
			-- Parsed as:
			-- void gtk_main (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_main		 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main_level: INTEGER is 
			-- Parsed as:
			-- guint gtk_main_level (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_main_level	 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main_quit is 
			-- Parsed as:
			-- void gtk_main_quit (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_main_quit	 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main_iteration: INTEGER is 
			-- Parsed as:
			-- gint gtk_main_iteration (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gint	   gtk_main_iteration	 (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_main_iteration_do (a_blocking: BOOLEAN): INTEGER is 
			-- Parsed as:
			-- gint gtk_main_iteration_do (
			--     gboolean a_blocking
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gint	   gtk_main_iteration_do (gboolean blocking);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_true: INTEGER is 
			-- Parsed as:
			-- gint gtk_true (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gint	   gtk_true		   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_false: INTEGER is 
			-- Parsed as:
			-- gint gtk_false (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- gint	   gtk_false		   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_grab_add (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_grab_add (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_grab_add		   (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_grab_get_current: POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_grab_get_current (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- GtkWidget* gtk_grab_get_current	   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_grab_remove (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_grab_remove (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_grab_remove	   (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_init_add (a_function: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_init_add (
			--     GtkFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_init_add		   (GtkFunction	       function,
			-- 				    gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_quit_add_destroy (a_main_level: INTEGER; a_object: POINTER) is 
			-- Parsed as:
			-- void gtk_quit_add_destroy (
			--     guint a_main_level,
			--     GtkObject *a_object
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_quit_add_destroy	   (guint	       main_level,
			-- 				    GtkObject	      *object);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_quit_add (a_main_level: INTEGER; a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_quit_add (
			--     guint a_main_level,
			--     GtkFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_quit_add		   (guint	       main_level,
			-- 				    GtkFunction	       function,
			-- 				    gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_quit_add_full (a_main_level: INTEGER; a_function: POINTER; a_marshal: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_quit_add_full (
			--     guint a_main_level,
			--     GtkFunction a_function,
			--     GtkCallbackMarshal a_marshal,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_quit_add_full	   (guint	       main_level,
			-- 				    GtkFunction	       function,
			-- 				    GtkCallbackMarshal marshal,
			-- 				    gpointer	       data,
			-- 				    GtkDestroyNotify   destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_quit_remove (a_quit_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_quit_remove (
			--     guint a_quit_handler_id
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_quit_remove	   (guint	       quit_handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_quit_remove_by_data (a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_quit_remove_by_data (
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_quit_remove_by_data (gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_timeout_add (a_interval: INTEGER; a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_timeout_add (
			--     guint32 a_interval,
			--     GtkFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_timeout_add	   (guint32	       interval,
			-- 				    GtkFunction	       function,
			-- 				    gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_timeout_add_full (a_interval: INTEGER; a_function: POINTER; a_marshal: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_timeout_add_full (
			--     guint32 a_interval,
			--     GtkFunction a_function,
			--     GtkCallbackMarshal a_marshal,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_timeout_add_full	   (guint32	       interval,
			-- 				    GtkFunction	       function,
			-- 				    GtkCallbackMarshal marshal,
			-- 				    gpointer	       data,
			-- 				    GtkDestroyNotify   destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_timeout_remove (a_timeout_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_timeout_remove (
			--     guint a_timeout_handler_id
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_timeout_remove	   (guint	       timeout_handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_idle_add (a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_idle_add (
			--     GtkFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_idle_add		   (GtkFunction	       function,
			-- 				    gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_idle_add_priority (a_priority: INTEGER; a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_idle_add_priority (
			--     gint a_priority,
			--     GtkFunction a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_idle_add_priority   (gint	       priority,
			-- 				    GtkFunction	       function,
			-- 				    gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_idle_add_full (a_priority: INTEGER; a_function: POINTER; a_marshal: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_idle_add_full (
			--     gint a_priority,
			--     GtkFunction a_function,
			--     GtkCallbackMarshal a_marshal,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_idle_add_full	   (gint	       priority,
			-- 				    GtkFunction	       function,
			-- 				    GtkCallbackMarshal marshal,
			-- 				    gpointer	       data,
			-- 				    GtkDestroyNotify   destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_idle_remove (a_idle_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_idle_remove (
			--     guint a_idle_handler_id
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_idle_remove	   (guint	       idle_handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_idle_remove_by_data (a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_idle_remove_by_data (
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_idle_remove_by_data (gpointer	       data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_input_add_full (a_source: INTEGER; a_condition: INTEGER; a_function: POINTER; a_marshal: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_input_add_full (
			--     gint a_source,
			--     GdkInputCondition a_condition,
			--     GdkInputFunction a_function,
			--     GtkCallbackMarshal a_marshal,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_input_add_full	   (gint	       source,
			-- 				    GdkInputCondition  condition,
			-- 				    GdkInputFunction   function,
			-- 				    GtkCallbackMarshal marshal,
			-- 				    gpointer	       data,
			-- 				    GtkDestroyNotify   destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_input_remove (a_input_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_input_remove (
			--     guint a_input_handler_id
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_input_remove	   (guint	       input_handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_key_snooper_install (a_snooper: POINTER; a_func_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_key_snooper_install (
			--     GtkKeySnoopFunc a_snooper,
			--     gpointer a_func_data
			-- );
			--
			-- Original C code from gtkmain.h:
			-- guint	   gtk_key_snooper_install (GtkKeySnoopFunc snooper,
			-- 				    gpointer	    func_data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_key_snooper_remove (a_snooper_handler_id: INTEGER) is 
			-- Parsed as:
			-- void gtk_key_snooper_remove (
			--     guint a_snooper_handler_id
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void	   gtk_key_snooper_remove  (guint	    snooper_handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_get_current_event: POINTER is 
			-- Parsed as:
			-- GdkEvent* gtk_get_current_event (
			-- );
			--
			-- Original C code from gtkmain.h:
			-- GdkEvent*  gtk_get_current_event   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_get_event_widget (a_event: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_get_event_widget (
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkmain.h:
			-- GtkWidget* gtk_get_event_widget	   (GdkEvent	   *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_propagate_event (a_widget: POINTER; a_event: POINTER) is 
			-- Parsed as:
			-- void gtk_propagate_event (
			--     GtkWidget *a_widget,
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkmain.h:
			-- void       gtk_propagate_event     (GtkWidget         *widget,
			-- 				    GdkEvent          *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_get_type: INTEGER is 
			-- Parsed as:
			-- guint gtk_color_selection_get_type (
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- guint      gtk_color_selection_get_type          (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_new: POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_color_selection_new (
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- GtkWidget* gtk_color_selection_new               (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_set_update_policy (a_colorsel: POINTER; a_policy: INTEGER) is 
			-- Parsed as:
			-- void gtk_color_selection_set_update_policy (
			--     GtkColorSelection *a_colorsel,
			--     GtkUpdateType a_policy
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- void       gtk_color_selection_set_update_policy (GtkColorSelection     *colorsel,
			--                                                   GtkUpdateType          policy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_set_opacity (a_colorsel: POINTER; a_use_opacity: INTEGER) is 
			-- Parsed as:
			-- void gtk_color_selection_set_opacity (
			--     GtkColorSelection *a_colorsel,
			--     gint a_use_opacity
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- void       gtk_color_selection_set_opacity       (GtkColorSelection     *colorsel,
			--                                                   gint                   use_opacity);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_set_color (a_colorsel: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_color_selection_set_color (
			--     GtkColorSelection *a_colorsel,
			--     gdouble *a_color
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- void       gtk_color_selection_set_color         (GtkColorSelection     *colorsel,
			-- 					          gdouble               *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_color_selection_get_color (a_colorsel: POINTER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_color_selection_get_color (
			--     GtkColorSelection *a_colorsel,
			--     gdouble *a_color
			-- );
			--
			-- Original C code from gtkcolorsel.h:
			-- void       gtk_color_selection_get_color         (GtkColorSelection     *colorsel,
			--                                                   gdouble               *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_new (a_targets: POINTER; a_ntargets: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkTargetList* gtk_target_list_new (
			--     GtkTargetEntry *a_targets,
			--     guint a_ntargets
			-- );
			--
			-- Original C code from gtkselection.h:
			-- GtkTargetList *gtk_target_list_new       (const GtkTargetEntry *targets,
			-- 					  guint                 ntargets);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_ref (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_target_list_ref (
			--     GtkTargetList *a_list
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void           gtk_target_list_ref       (GtkTargetList  *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_unref (a_list: POINTER) is 
			-- Parsed as:
			-- void gtk_target_list_unref (
			--     GtkTargetList *a_list
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void           gtk_target_list_unref     (GtkTargetList  *list);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_add (a_list: POINTER; a_target: INTEGER; a_flags: INTEGER; a_info: INTEGER) is 
			-- Parsed as:
			-- void gtk_target_list_add (
			--     GtkTargetList *a_list,
			--     GdkAtom a_target,
			--     guint a_flags,
			--     guint a_info
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void           gtk_target_list_add       (GtkTargetList  *list,
			-- 				  	  GdkAtom         target,
			-- 					  guint           flags,
			-- 					  guint           info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_add_table (a_list: POINTER; a_targets: POINTER; a_ntargets: INTEGER) is 
			-- Parsed as:
			-- void gtk_target_list_add_table (
			--     GtkTargetList *a_list,
			--     GtkTargetEntry *a_targets,
			--     guint a_ntargets
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void           gtk_target_list_add_table (GtkTargetList        *list,
			-- 					  const GtkTargetEntry *targets,
			-- 					  guint                 ntargets);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_remove (a_list: POINTER; a_target: INTEGER) is 
			-- Parsed as:
			-- void gtk_target_list_remove (
			--     GtkTargetList *a_list,
			--     GdkAtom a_target
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void           gtk_target_list_remove    (GtkTargetList  *list,
			-- 					  GdkAtom         target);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_target_list_find (a_list: POINTER; a_target: INTEGER; a_info: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_target_list_find (
			--     GtkTargetList *a_list,
			--     GdkAtom a_target,
			--     guint *a_info
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gboolean       gtk_target_list_find      (GtkTargetList  *list,
			-- 					  GdkAtom         target,
			-- 					  guint          *info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_owner_set (a_widget: POINTER; a_selection: INTEGER; a_time: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_owner_set (
			--     GtkWidget *a_widget,
			--     GdkAtom a_selection,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_owner_set (GtkWidget 	  *widget,
			-- 			      GdkAtom    	   selection,
			-- 			      guint32    	   time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_add_target (a_widget: POINTER; a_selection: INTEGER; a_target: INTEGER; a_info: INTEGER) is 
			-- Parsed as:
			-- void gtk_selection_add_target (
			--     GtkWidget *a_widget,
			--     GdkAtom a_selection,
			--     GdkAtom a_target,
			--     guint a_info
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void gtk_selection_add_target (GtkWidget           *widget, 
			-- 			       GdkAtom              selection,
			-- 			       GdkAtom              target,
			-- 			       guint                info);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_add_targets (a_widget: POINTER; a_selection: INTEGER; a_targets: POINTER; a_ntargets: INTEGER) is 
			-- Parsed as:
			-- void gtk_selection_add_targets (
			--     GtkWidget *a_widget,
			--     GdkAtom a_selection,
			--     GtkTargetEntry *a_targets,
			--     guint a_ntargets
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void gtk_selection_add_targets (GtkWidget            *widget, 
			-- 				GdkAtom               selection,
			-- 				const GtkTargetEntry *targets,
			-- 				guint                 ntargets);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_convert (a_widget: POINTER; a_selection: INTEGER; a_target: INTEGER; a_time: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_convert (
			--     GtkWidget *a_widget,
			--     GdkAtom a_selection,
			--     GdkAtom a_target,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_convert   (GtkWidget 	  *widget, 
			-- 			      GdkAtom    	   selection, 
			-- 			      GdkAtom    	   target,
			-- 			      guint32    	   time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_data_set (a_selection_data: POINTER; a_type: INTEGER; a_format: INTEGER; a_data: POINTER; a_length: INTEGER) is 
			-- Parsed as:
			-- void gtk_selection_data_set (
			--     GtkSelectionData *a_selection_data,
			--     GdkAtom a_type,
			--     gint a_format,
			--     guchar *a_data,
			--     gint a_length
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void gtk_selection_data_set (GtkSelectionData *selection_data,
			-- 			     GdkAtom           type,
			-- 			     gint              format,
			-- 			     guchar           *data,
			-- 			     gint              length);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_remove_all (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_selection_remove_all (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void gtk_selection_remove_all      (GtkWidget *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_clear (a_widget: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_clear (
			--     GtkWidget *a_widget,
			--     GdkEventSelection *a_event
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_clear           (GtkWidget 	      *widget,
			-- 				    GdkEventSelection *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_request (a_widget: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_request (
			--     GtkWidget *a_widget,
			--     GdkEventSelection *a_event
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_request         (GtkWidget  	      *widget,
			-- 				    GdkEventSelection *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_incr_event (a_window: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_incr_event (
			--     GdkWindow *a_window,
			--     GdkEventProperty *a_event
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_incr_event      (GdkWindow         *window,
			-- 				    GdkEventProperty  *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_notify (a_widget: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_notify (
			--     GtkWidget *a_widget,
			--     GdkEventSelection *a_event
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_notify          (GtkWidget         *widget,
			-- 				    GdkEventSelection *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_property_notify (a_widget: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_selection_property_notify (
			--     GtkWidget *a_widget,
			--     GdkEventProperty *a_event
			-- );
			--
			-- Original C code from gtkselection.h:
			-- gint gtk_selection_property_notify (GtkWidget         *widget,
			-- 				    GdkEventProperty  *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_data_copy (a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GtkSelectioData* gtk_selection_data_copy (
			--     GtkSelectionData *a_data
			-- );
			--
			-- Original C code from gtkselection.h:
			-- GtkSelectioData *gtk_selection_data_copy (GtkSelectionData *data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_selection_data_free (a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_selection_data_free (
			--     GtkSelectionData *a_data
			-- );
			--
			-- Original C code from gtkselection.h:
			-- void		 gtk_selection_data_free (GtkSelectionData *data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_get_data (a_widget: POINTER; a_context: POINTER; a_target: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_get_data (
			--     GtkWidget *a_widget,
			--     GdkDragContext *a_context,
			--     GdkAtom a_target,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_get_data (GtkWidget      *widget,
			-- 			GdkDragContext *context,
			-- 			GdkAtom         target,
			-- 			guint32         time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_finish (a_context: POINTER; a_success: BOOLEAN; a_del: BOOLEAN; a_time: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_finish (
			--     GdkDragContext *a_context,
			--     gboolean a_success,
			--     gboolean a_del,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_finish   (GdkDragContext *context,
			-- 			gboolean        success,
			-- 			gboolean        del,
			-- 			guint32         time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_get_source_widget (a_context: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_drag_get_source_widget (
			--     GdkDragContext *a_context
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- GtkWidget *gtk_drag_get_source_widget (GdkDragContext *context);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_highlight (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_highlight (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_highlight   (GtkWidget  *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_unhighlight (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_unhighlight (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_unhighlight (GtkWidget  *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_dest_set (a_widget: POINTER; a_flags: INTEGER; a_targets: POINTER; a_n_targets: INTEGER; a_actions: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_dest_set (
			--     GtkWidget *a_widget,
			--     GtkDestDefaults a_flags,
			--     GtkTargetEntry *a_targets,
			--     gint a_n_targets,
			--     GdkDragAction a_actions
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_dest_set   (GtkWidget            *widget,
			-- 			  GtkDestDefaults       flags,
			--   		          const GtkTargetEntry *targets,
			-- 			  gint                  n_targets,
			-- 			  GdkDragAction         actions);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_dest_set_proxy (a_widget: POINTER; a_proxy_window: POINTER; a_protocol: INTEGER; a_use_coordinates: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_drag_dest_set_proxy (
			--     GtkWidget *a_widget,
			--     GdkWindow *a_proxy_window,
			--     GdkDragProtocol a_protocol,
			--     gboolean a_use_coordinates
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_dest_set_proxy (GtkWidget      *widget,
			-- 			      GdkWindow      *proxy_window,
			-- 			      GdkDragProtocol protocol,
			-- 			      gboolean        use_coordinates);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_dest_unset (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_dest_unset (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_dest_unset (GtkWidget          *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_source_set (a_widget: POINTER; a_start_button_mask: INTEGER; a_targets: POINTER; a_n_targets: INTEGER; a_actions: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_source_set (
			--     GtkWidget *a_widget,
			--     GdkModifierType a_start_button_mask,
			--     GtkTargetEntry *a_targets,
			--     gint a_n_targets,
			--     GdkDragAction a_actions
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_source_set  (GtkWidget            *widget,
			-- 			   GdkModifierType       start_button_mask,
			-- 			   const GtkTargetEntry *targets,
			-- 			   gint                  n_targets,
			-- 			   GdkDragAction         actions);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_source_unset (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_source_unset (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_source_unset (GtkWidget        *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_source_set_icon (a_widget: POINTER; a_colormap: POINTER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_source_set_icon (
			--     GtkWidget *a_widget,
			--     GdkColormap *a_colormap,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_source_set_icon (GtkWidget     *widget,
			-- 			       GdkColormap   *colormap,
			-- 			       GdkPixmap     *pixmap,
			-- 			       GdkBitmap     *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_begin (a_widget: POINTER; a_targets: POINTER; a_actions: INTEGER; a_button: INTEGER; a_event: POINTER): POINTER is 
			-- Parsed as:
			-- GdkDragContext* gtk_drag_begin (
			--     GtkWidget *a_widget,
			--     GtkTargetList *a_targets,
			--     GdkDragAction a_actions,
			--     gint a_button,
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- GdkDragContext *gtk_drag_begin (GtkWidget         *widget,
			-- 				GtkTargetList     *targets,
			-- 				GdkDragAction      actions,
			-- 				gint               button,
			-- 				GdkEvent          *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_set_icon_widget (a_context: POINTER; a_widget: POINTER; a_hot_x: INTEGER; a_hot_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_set_icon_widget (
			--     GdkDragContext *a_context,
			--     GtkWidget *a_widget,
			--     gint a_hot_x,
			--     gint a_hot_y
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_set_icon_widget  (GdkDragContext    *context,
			-- 				GtkWidget         *widget,
			-- 				gint               hot_x,
			-- 				gint               hot_y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_set_icon_pixmap (a_context: POINTER; a_colormap: POINTER; a_pixmap: POINTER; a_mask: POINTER; a_hot_x: INTEGER; a_hot_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_set_icon_pixmap (
			--     GdkDragContext *a_context,
			--     GdkColormap *a_colormap,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask,
			--     gint a_hot_x,
			--     gint a_hot_y
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_set_icon_pixmap  (GdkDragContext    *context,
			-- 				GdkColormap       *colormap,
			-- 				GdkPixmap         *pixmap,
			-- 				GdkBitmap         *mask,
			-- 				gint               hot_x,
			-- 				gint               hot_y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_set_icon_default (a_context: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_set_icon_default (
			--     GdkDragContext *a_context
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_set_icon_default (GdkDragContext    *context);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_set_default_icon (a_colormap: POINTER; a_pixmap: POINTER; a_mask: POINTER; a_hot_x: INTEGER; a_hot_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_drag_set_default_icon (
			--     GdkColormap *a_colormap,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask,
			--     gint a_hot_x,
			--     gint a_hot_y
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_set_default_icon (GdkColormap   *colormap,
			-- 				GdkPixmap     *pixmap,
			-- 				GdkBitmap     *mask,
			-- 			        gint           hot_x,
			-- 			        gint           hot_y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_source_handle_event (a_widget: POINTER; a_event: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_source_handle_event (
			--     GtkWidget *a_widget,
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_source_handle_event (GtkWidget *widget,
			-- 				   GdkEvent  *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_drag_dest_handle_event (a_toplevel: POINTER; a_event: POINTER) is 
			-- Parsed as:
			-- void gtk_drag_dest_handle_event (
			--     GtkWidget *a_toplevel,
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkdnd.h:
			-- void gtk_drag_dest_handle_event (GtkWidget *toplevel,
			-- 				 GdkEvent  *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_font_selection_get_type (
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- GtkType	   gtk_font_selection_get_type		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_new: POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_font_selection_new (
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- GtkWidget* gtk_font_selection_new		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_get_font_name (a_fontsel: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_font_selection_get_font_name (
			--     GtkFontSelection *a_fontsel
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- gchar*	   gtk_font_selection_get_font_name	(GtkFontSelection *fontsel);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_get_font (a_fontsel: POINTER): POINTER is 
			-- Parsed as:
			-- GdkFont* gtk_font_selection_get_font (
			--     GtkFontSelection *a_fontsel
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- GdkFont*   gtk_font_selection_get_font		(GtkFontSelection *fontsel);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_set_font_name (a_fontsel: POINTER; a_fontname: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_font_selection_set_font_name (
			--     GtkFontSelection *a_fontsel,
			--     gchar *a_fontname
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- gboolean   gtk_font_selection_set_font_name	(GtkFontSelection *fontsel,
			-- 						 const gchar	  *fontname);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_set_filter (a_fontsel: POINTER; a_filter_type: INTEGER; a_font_type: INTEGER; a_foundries: POINTER; a_weights: POINTER; a_slants: POINTER; a_setwidths: POINTER; a_spacings: POINTER; a_charsets: POINTER) is 
			-- Parsed as:
			-- void gtk_font_selection_set_filter (
			--     GtkFontSelection *a_fontsel,
			--     GtkFontFilterType a_filter_type,
			--     GtkFontType a_font_type,
			--     gchar **a_foundries,
			--     gchar **a_weights,
			--     gchar **a_slants,
			--     gchar **a_setwidths,
			--     gchar **a_spacings,
			--     gchar **a_charsets
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- void	   gtk_font_selection_set_filter	(GtkFontSelection *fontsel,
			-- 						 GtkFontFilterType filter_type,
			-- 						 GtkFontType	   font_type,
			-- 						 gchar		 **foundries,
			-- 						 gchar		 **weights,
			-- 						 gchar		 **slants,
			-- 						 gchar		 **setwidths,
			-- 						 gchar		 **spacings,
			-- 						 gchar		 **charsets);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_get_preview_text (a_fontsel: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_font_selection_get_preview_text (
			--     GtkFontSelection *a_fontsel
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- gchar*	   gtk_font_selection_get_preview_text	(GtkFontSelection *fontsel);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_font_selection_set_preview_text (a_fontsel: POINTER; a_text: POINTER) is 
			-- Parsed as:
			-- void gtk_font_selection_set_preview_text (
			--     GtkFontSelection *a_fontsel,
			--     gchar *a_text
			-- );
			--
			-- Original C code from gtkfontsel.h:
			-- void	   gtk_font_selection_set_preview_text	(GtkFontSelection *fontsel,
			-- 						 const gchar	  *text);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_gc_get (a_depth: INTEGER; a_colormap: POINTER; a_values: POINTER; a_values_mask: INTEGER): POINTER is 
			-- Parsed as:
			-- GdkGC* gtk_gc_get (
			--     gint a_depth,
			--     GdkColormap *a_colormap,
			--     GdkGCValues *a_values,
			--     GdkGCValuesMask a_values_mask
			-- );
			--
			-- Original C code from gtkgc.h:
			-- GdkGC* gtk_gc_get     (gint             depth,
			-- 		       GdkColormap     *colormap,
			-- 		       GdkGCValues     *values,
			-- 		       GdkGCValuesMask  values_mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_gc_release (a_gc: POINTER) is 
			-- Parsed as:
			-- void gtk_gc_release (
			--     GdkGC *a_gc
			-- );
			--
			-- Original C code from gtkgc.h:
			-- void   gtk_gc_release (GdkGC           *gc);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_new (a_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkMenuFactory* gtk_menu_factory_new (
			--     GtkMenuFactoryType a_type
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- GtkMenuFactory* gtk_menu_factory_new		   (GtkMenuFactoryType	type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_destroy (a_factory: POINTER) is 
			-- Parsed as:
			-- void gtk_menu_factory_destroy (
			--     GtkMenuFactory *a_factory
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_destroy	   (GtkMenuFactory     *factory);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_add_entries (a_factory: POINTER; a_entries: POINTER; a_nentries: INTEGER) is 
			-- Parsed as:
			-- void gtk_menu_factory_add_entries (
			--     GtkMenuFactory *a_factory,
			--     GtkMenuEntry *a_entries,
			--     int a_nentries
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_add_entries	   (GtkMenuFactory     *factory,
			-- 						    GtkMenuEntry       *entries,
			-- 						    int			nentries);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_add_subfactory (a_factory: POINTER; a_subfactory: POINTER; a_path: POINTER) is 
			-- Parsed as:
			-- void gtk_menu_factory_add_subfactory (
			--     GtkMenuFactory *a_factory,
			--     GtkMenuFactory *a_subfactory,
			--     char *a_path
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_add_subfactory	   (GtkMenuFactory     *factory,
			-- 						    GtkMenuFactory     *subfactory,
			-- 						    const char	       *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_remove_paths (a_factory: POINTER; a_paths: POINTER; a_npaths: INTEGER) is 
			-- Parsed as:
			-- void gtk_menu_factory_remove_paths (
			--     GtkMenuFactory *a_factory,
			--     char **a_paths,
			--     int a_npaths
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_remove_paths	   (GtkMenuFactory     *factory,
			-- 						    char	      **paths,
			-- 						    int			npaths);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_remove_entries (a_factory: POINTER; a_entries: POINTER; a_nentries: INTEGER) is 
			-- Parsed as:
			-- void gtk_menu_factory_remove_entries (
			--     GtkMenuFactory *a_factory,
			--     GtkMenuEntry *a_entries,
			--     int a_nentries
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_remove_entries	   (GtkMenuFactory     *factory,
			-- 						    GtkMenuEntry       *entries,
			-- 						    int			nentries);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_remove_subfactory (a_factory: POINTER; a_subfactory: POINTER; a_path: POINTER) is 
			-- Parsed as:
			-- void gtk_menu_factory_remove_subfactory (
			--     GtkMenuFactory *a_factory,
			--     GtkMenuFactory *a_subfactory,
			--     char *a_path
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- void		gtk_menu_factory_remove_subfactory (GtkMenuFactory     *factory,
			-- 						    GtkMenuFactory     *subfactory,
			-- 						    const char	       *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_menu_factory_find (a_factory: POINTER; a_path: POINTER): POINTER is 
			-- Parsed as:
			-- GtkMenuPath* gtk_menu_factory_find (
			--     GtkMenuFactory *a_factory,
			--     char *a_path
			-- );
			--
			-- Original C code from gtkmenufactory.h:
			-- GtkMenuPath*	gtk_menu_factory_find		   (GtkMenuFactory     *factory,
			-- 						    const char	       *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factories_path_delete (a_ifactory_path: POINTER; a_path: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factories_path_delete (
			--     gchar *a_ifactory_path,
			--     gchar *a_path
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factories_path_delete	   (const gchar		*ifactory_path,
			-- 					    const gchar		*path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_init is 
			-- Parsed as:
			-- void gtk_rc_init (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_init			(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_add_default_file (a_filename: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_add_default_file (
			--     gchar *a_filename
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void      gtk_rc_add_default_file    (const gchar *filename);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_set_default_files (a_filenames: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_set_default_files (
			--     gchar **a_filenames
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void      gtk_rc_set_default_files      (gchar **filenames);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_get_default_files: POINTER is 
			-- Parsed as:
			-- gchar** gtk_rc_get_default_files (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gchar**   gtk_rc_get_default_files      (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_parse (a_filename: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_parse (
			--     gchar *a_filename
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_parse			(const gchar *filename);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_parse_string (a_rc_string: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_parse_string (
			--     gchar *a_rc_string
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_parse_string		(const gchar *rc_string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_reparse_all: BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_rc_reparse_all (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gboolean  gtk_rc_reparse_all		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_get_style (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_rc_get_style (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkrc.h:
			-- GtkStyle* gtk_rc_get_style		(GtkWidget   *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_add_widget_name_style (a_rc_style: POINTER; a_pattern: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_add_widget_name_style (
			--     GtkRcStyle *a_rc_style,
			--     gchar *a_pattern
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_add_widget_name_style	(GtkRcStyle  *rc_style,
			-- 					 const gchar *pattern);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_add_widget_class_style (a_rc_style: POINTER; a_pattern: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_add_widget_class_style (
			--     GtkRcStyle *a_rc_style,
			--     gchar *a_pattern
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_add_widget_class_style (GtkRcStyle  *rc_style,
			-- 					 const gchar *pattern);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_add_class_style (a_rc_style: POINTER; a_pattern: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_add_class_style (
			--     GtkRcStyle *a_rc_style,
			--     gchar *a_pattern
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void	  gtk_rc_add_class_style	(GtkRcStyle  *rc_style,
			-- 					 const gchar *pattern);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_style_new: POINTER is 
			-- Parsed as:
			-- GtkRcStyle* gtk_rc_style_new (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- GtkRcStyle* gtk_rc_style_new              (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_style_ref (a_rc_style: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_style_ref (
			--     GtkRcStyle *a_rc_style
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void        gtk_rc_style_ref              (GtkRcStyle  *rc_style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_style_unref (a_rc_style: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_style_unref (
			--     GtkRcStyle *a_rc_style
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void        gtk_rc_style_unref            (GtkRcStyle  *rc_style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_set_image_loader (a_loader: POINTER) is 
			-- Parsed as:
			-- void gtk_rc_set_image_loader (
			--     GtkImageLoader a_loader
			-- );
			--
			-- Original C code from gtkrc.h:
			-- void		gtk_rc_set_image_loader      	(GtkImageLoader	 loader);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_load_image (a_colormap: POINTER; a_transparent_color: POINTER; a_filename: POINTER): POINTER is 
			-- Parsed as:
			-- GdkPixmap* gtk_rc_load_image (
			--     GdkColormap *a_colormap,
			--     GdkColor *a_transparent_color,
			--     gchar *a_filename
			-- );
			--
			-- Original C code from gtkrc.h:
			-- GdkPixmap*	gtk_rc_load_image		(GdkColormap 	*colormap,
			-- 						 GdkColor    	*transparent_color,
			-- 						 const gchar 	*filename);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_find_pixmap_in_path (a_scanner: POINTER; a_pixmap_file: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_rc_find_pixmap_in_path (
			--     GScanner *a_scanner,
			--     gchar *a_pixmap_file
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gchar*		gtk_rc_find_pixmap_in_path	(GScanner    	*scanner,
			-- 						 const gchar	*pixmap_file);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_find_module_in_path (a_module_file: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_rc_find_module_in_path (
			--     gchar *a_module_file
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gchar*		gtk_rc_find_module_in_path	(const gchar 	*module_file);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_get_theme_dir: POINTER is 
			-- Parsed as:
			-- gchar* gtk_rc_get_theme_dir (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gchar*		gtk_rc_get_theme_dir		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_get_module_dir: POINTER is 
			-- Parsed as:
			-- gchar* gtk_rc_get_module_dir (
			-- );
			--
			-- Original C code from gtkrc.h:
			-- gchar*		gtk_rc_get_module_dir		(void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_parse_color (a_scanner: POINTER; a_color: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_rc_parse_color (
			--     GScanner *a_scanner,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gtkrc.h:
			-- guint	gtk_rc_parse_color	(GScanner	     *scanner,
			-- 				 GdkColor	     *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_parse_state (a_scanner: POINTER; a_state: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_rc_parse_state (
			--     GScanner *a_scanner,
			--     GtkStateType *a_state
			-- );
			--
			-- Original C code from gtkrc.h:
			-- guint	gtk_rc_parse_state	(GScanner	     *scanner,
			-- 				 GtkStateType	     *state);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_rc_parse_priority (a_scanner: POINTER; a_priority: POINTER): INTEGER is 
			-- Parsed as:
			-- guint gtk_rc_parse_priority (
			--     GScanner *a_scanner,
			--     GtkPathPriorityType *a_priority
			-- );
			--
			-- Original C code from gtkrc.h:
			-- guint	gtk_rc_parse_priority	(GScanner	     *scanner,
			-- 				 GtkPathPriorityType *priority);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_theme_engine_get (a_name: POINTER): POINTER is 
			-- Parsed as:
			-- GtkThemeEngine* gtk_theme_engine_get (
			--     gchar *a_name
			-- );
			--
			-- Original C code from gtkthemes.h:
			-- GtkThemeEngine *gtk_theme_engine_get   (gchar          *name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_theme_engine_ref (a_engine: POINTER) is 
			-- Parsed as:
			-- void gtk_theme_engine_ref (
			--     GtkThemeEngine *a_engine
			-- );
			--
			-- Original C code from gtkthemes.h:
			-- void            gtk_theme_engine_ref   (GtkThemeEngine *engine);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_theme_engine_unref (a_engine: POINTER) is 
			-- Parsed as:
			-- void gtk_theme_engine_unref (
			--     GtkThemeEngine *a_engine
			-- );
			--
			-- Original C code from gtkthemes.h:
			-- void            gtk_theme_engine_unref (GtkThemeEngine *engine);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_themes_init (a_argc: POINTER; a_argv: POINTER) is 
			-- Parsed as:
			-- void gtk_themes_init (
			--     int *a_argc,
			--     char ***a_argv
			-- );
			--
			-- Original C code from gtkthemes.h:
			-- void	   gtk_themes_init	 (int	       *argc,
			-- 				  char	     ***argv);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_themes_exit (a_error_code: INTEGER) is 
			-- Parsed as:
			-- void gtk_themes_exit (
			--     gint a_error_code
			-- );
			--
			-- Original C code from gtkthemes.h:
			-- void	   gtk_themes_exit	 (gint		error_code);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_EXTERNALS

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)