#!/usr/bin/perl -w
#===============================================================================
# c_enum_dump.pl
#-------------------------------------------------------------------------------
# Takes path to some C source
# Produces list of enum names found, one per line
# BROKEN, UNFINISHED
#===============================================================================


#===============================================================================
# Start of execution
#===============================================================================

# Did we get the C source path on the command line?
if ($#ARGV != 0) {
	print ("usage: c_enum_dump.pl path_to_source\n");
	exit 1
}
$dir = $ARGV[0];

# Get a list of header files.
@hfiles = <$dir/gtk*.h>;
if (@hfiles == 0) {
	# Oops, where are the files?
	print ("$dir? Sorry, I can't see any C source there.\n");
	exit 1
}

$ws = "[ 	]";
$id = "[a-zA-Z][_a-zA-Z0-9]*";
$enumel = "$id($ws*\"=\"$ws*[^,}]+)?";

# Look at each file.
foreach (@hfiles) {
	$file = $_;
	open (HFILE, $file);
	$/ = ";";
	while (<HFILE>) {
		#if (/enum($ws+$id)?$ws*{$ws*$enumel($ws*,$ws*$enumel)*$ws*}/) {
		if (/enum[ 	]+/) {
			print;
		}
	}
}


#===============================================================================
# End of file
#===============================================================================

#WS     [ \r\f\v\t\n]
#ID     [a-zA-Z][_a-zA-Z0-9]*
#ENUMEL {ID}({WS}*"="{WS}*[^,}]+)?
#ENUM   enum({WS}+{ID})?{WS}*"{"{WS}*{ENUMEL}({WS}*","{WS}*{ENUMEL})*{WS}*"}"
#ASSIGN "="{WS}*[^,}]+
