-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
class TEST_GTK

inherit

	GTK_APPLICATION

	GTK_CONSTANTS

creation

	make

feature

	make is
		do
			print ("*** Starting test_gtk %N")
			initialize_tool_kit
			set_locale 
--			parse_rc_file ("/home/nrichieb/Eiffel/gtk/examples/testgtk/testgtkrc")
			create_main_window
			wait_for_events
		end

feature -- tests for all the widgets

	window: GTK_WINDOW
	quit: QUIT_COMMAND
	exit_command: EXIT_COMMAND

	box1, box2: GTK_BOX
	scrolled_window: GTK_SCROLLED_WINDOW
	separator: GTK_SEPARATOR
	-- buttons
	close_button: GTK_BUTTON


	create_main_window is
		do
			-- Create the window and set the quit command
			!!window.make_top_level
			window.set_title ("Main Window")
			window.set_size (200, 400)
			window.set_position (20, 20)
			!!quit.make (window)
			-- make a box for widgets
			!!box1.make_vertical (False, 0)
			window.add_widget (box1)
			-- make a scrolled region
			!!scrolled_window.make
			scrolled_window.set_border_width (10)
			scrolled_window.set_policy (GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC)
			box1.pack (scrolled_window, True, True, 0)
			-- make another box for buttons
			!!box2.make_vertical (False, 0)
			box2.set_border_width (10)
			scrolled_window.add_widget_with_viewport (box2)
			-- now make buttons in the new box
			make_buttons (box2)
			-- Make a button for closing the window
			!!separator.make_horizontal
			box1.pack (separator, False, False, 0)
			-- Make another box
			!!box2.make_vertical (False, 10)
			box1.pack (box2, False, True, 0)
			box2.set_border_width (10)
			!!close_button.make_with_label ("close")
			!!exit_command
			-- exit_command.connect ("clicked", close_button)
			close_button.add_action ("clicked", exit_command)
			box2.pack (close_button, True, True, 0)
			close_button.set_flags (close_button.Gtk_can_default)
			close_button.grab_default
			-- show all widgets
			window.show_all
		end
	
feature -- buttons

	labels: ARRAY [STRING] is
		once
			Result := <<"buttons",
						"toggle buttons",
						"check buttons",
						"radio buttons",
						"button box",
						"toolbar",
						"handle box",
						"reparent",
						"pixmap",
						"tooltips",
						"menus",
						"scrolled windows",
						"drawing areas",
						"entry",
						"list",
						"clist",
						"color selection",
						"file selection",
						"dialog",
						"miscellaneous",
						"range controls",
						"rulers",
						"text",
						"note book",
						"panes",
						"shapes",
						"dnd",
						"progress bar",
						"preview color",
						"preview gray",
						"gamma curve",
						"test scrolling",
						"test selection",
						"test timeout",
						"test idle"
						>>
		end

	buttons: ARRAY [GTK_BUTTON]

	command: ARRAY [GTK_COMMAND] is
		local
			cmd: GTK_COMMAND
			i: INTEGER
		once
			!!Result.make (1, buttons.upper)
			!TOOLBARS!cmd
			Result.put (cmd, 6)

			!BUTTONS!cmd
			Result.put (cmd, 1)
			!TOGGLE_BUTTONS!cmd
			Result.put (cmd, 2)
			!CHECK_BUTTONS!cmd
			Result.put (cmd, 3)
			!RADIO_BUTTONS!cmd
			Result.put (cmd, 4)
			-- TODO: Button box widget and example
			!REPARENT!cmd
			-- TODO: Handle Box
			Result.put (cmd, 8)
			-- TODO: pixmap
			!TOOLTIPS!cmd
			Result.put (cmd, 10)
			-- TODO: menus
			-- TODO: scrolled windows
			-- TODO: drawing areas
			!TEXT_ENTRY!cmd
			Result.put (cmd, 14)
			!LIST_CMD!cmd
			Result.put (cmd, 15)

			!COLOR_SELECTION_CMD!cmd
			Result.put (cmd, 17)

			!FILE_SELECTION_CMD!cmd
			Result.put (cmd, 18)
			!DIALOG_CMD!cmd
			Result.put (cmd, 19)
			!NOTEBOOK_CMD!cmd
			Result.put (cmd, 24)
			!GAMMA_CURVE_CMD!cmd
			Result.put (cmd, 31)
		end

	make_buttons (box: GTK_BOX) is
		local
			button: GTK_BUTTON
			cmd: GTK_COMMAND
			i: INTEGER
		do
			!!buttons.make (1, labels.count)
			from i := 1
			until i > buttons.upper
			loop
				!!button.make_with_label (labels @ i)
				if command @ i = Void then
					button.set_sensitive (False)
				else
					-- command.item(i).connect ("clicked", button)
					button.add_action ("clicked", command @ i)
				end
				buttons.put (button, i)
				box.pack (button, True, True, 0)
				i := i + 1
			end
		end

end
