-- cOpyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkFrame objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_FRAME_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is
		once
			Result := "GTK_FRAME"
		end
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			if widget_tree.find_child("label") /= Void then
				label := widget_tree.get_string_from_field("label")
			end
			label_xalign := widget_tree.get_string_from_field("label_xalign")
			shadow_type := widget_tree.get_string_from_field("shadow_type")
			create_child_class(widget_tree.find_child("widget"))
		end
			
	label: STRING
	label_xalign: STRING
	shadow_type: STRING

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			Result := precursor
			!!temp.make_with_name("GTK_SHADOWTYPE_ENUM")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

	creation_feature: STRING is
		do
			if label /= Void then
				Result := "!!" + name + ".make(%""+label+"%")"
			else
				Result := "!!" + name + ".make_no_label"
			end
		end
			
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last(creation_feature)
			code.add_last(name + ".align_label(" + label_xalign + ")")
			code.add_last(name + ".set_shadow_type(" + shadow_type + ")")
			add_widget_code(code)
			precursor(code)
		end

end
