-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkDialog objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_DIALOG_WRITER

inherit

	GTK_CLASS_WRITER
		rename
			make as make_class
		redefine
			inherit_klass
		end

	SIGNAL_COMMON

creation

	make

feature

	name: STRING
	
	inherit_from: STRING is "GTK_DIALOG"

	vbox: TAG_TREE
	vbox_widgets: ARRAY[CAN_BE_CREATED]
	action_area: TAG_TREE
	action_area_widgets: ARRAY[CAN_BE_CREATED]

	inherit_klass: KLASS is
		do
			!!Result.make_with_name(inherit_from)
			Result.add_rename_clause("make", "make_dialog")
		end
	
	create_child_class_array_ignore_action_area(tree_array: ARRAY[TAG_TREE]) is
		local
			i, j: INTEGER
		do
			if tree_array = Void or else tree_array.count = 0 then
				last_class_array := Void
			else
				!!last_class_array.make(0,0)
				from
					i := 0
					j := 0
				until
					i >= tree_array.count
				loop
					if (tree_array @ i).get_string_from_field("child_name").is_equal("Dialog:action_area") then
						action_area := tree_array @ i
					else
						create_child_class(tree_array @ i)
						if last_class /= Void then
							last_class_array.force(last_class, j)
							inherit_list.merge_with(last_class.parent_inherit)
							j := j + 1
						end
					end
					i := i + 1
				end
			end
		end
		
	make(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
		local
			action_area_info: CLASS_INFO
			vbox_info: CLASS_INFO
			i: INTEGER
		do
			make_class(tree, info, src)
			vbox := widget_tree.find_child("widget")
			!!vbox_info.make(vbox)
			if vbox_info.class_name.is_equal("GtkVBox") then
				create_child_class_array_ignore_action_area(vbox.find_children("widget"))
				vbox_widgets := last_class_array
				!!action_area_info.make(action_area)
				if action_area_info.class_name.is_equal("GtkHBox") then
					create_child_class_array(action_area.find_children("widget"))
					action_area_widgets := last_class_array
					from
						i := 0
					until
						i >= action_area_widgets.count
					loop
						inherit_list.merge_with((action_area_widgets @ i).parent_inherit)
						i := i + 1
					end
				end
			end
			
			border_width := widget_tree.get_integer_string_from_field("border_width")
			title := widget_tree.get_string_from_field("title")
			type := widget_tree.get_string_from_field("type")
			position := widget_tree.get_string_from_field("position")
			modal := widget_tree.get_boolean_string_from_field("modal")
			if modal = "" then
				modal := "False"
			end
			allow_shrink := widget_tree.get_boolean_string_from_field("allow_shrink")
			if allow_shrink = "" then
				allow_shrink := "True"
			end
			allow_grow := widget_tree.get_boolean_string_from_field("allow_grow")
			if allow_grow = "" then
				allow_grow := "True"
			end
			auto_shrink := widget_tree.get_boolean_string_from_field("auto_shrink")
			if auto_shrink = "" then
				auto_shrink := "True"
			end
			name := clone(classname)
			name.to_lower
			name.prepend("instance_")
		end
			
	title: STRING
	type: STRING
	position: STRING
	modal: STRING
	allow_shrink: STRING
	allow_grow: STRING
	auto_shrink: STRING
	border_width: STRING
	visible: BOOLEAN
	events: STRING
	extension_events: STRING
	wm_name: STRING
	wm_class: STRING

	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name+": "+classname)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			if visible then
				code.add_last(name + ".show")
			end
		end

	append_top_level_definition(code: ARRAY[STRING]) is
		do
			code.add_last(name + ": " + classname + " is")
			code.add_last("%Tonce")
			code.add_last("%T%T!!Result.make")
			code.add_last("%Tend%N")
		end

	append_top_level_show(code: ARRAY[STRING]) is
		do
			if visible then
				code.add_last(name + ".show")
			end
		end

	write_features is
		local
			i: INTEGER
			code: ARRAY[STRING]
		do
			!!code.make(0,-1)
			from
				i := 0
			until
				i >= vbox_widgets.count
			loop
				if (vbox_widgets @ i) /= Void then
					code.clear;
					(vbox_widgets @ i).append_parent_declaration(code)
					-- code is written as soon as possible to reduce memory
					-- consumption
					write_lines(code)
				end
				i := i + 1
			end

			from
				i := 0
			until
				i >= action_area_widgets.count
			loop
				if (action_area_widgets @ i) /= Void then
					code.clear;
					(action_area_widgets @ i).append_parent_declaration(code)
					write_lines(code)
				end
				i := i + 1
			end
			
		end

	write_make_body is
		local
			temp_child: CHILD
			i: INTEGER
			code: ARRAY[STRING]
		do
			!!code.make(0,-1)
			append_signal_declarations(code)
			write_lines(code)
			write_line("make is")
			indent
			write_line("local")
			write_line("do")
			indent
			write_line("make_dialog")
			write_line("set_title(%""+title+"%")")
			write_line("set_policy("+allow_shrink+", "+allow_grow+", "+auto_shrink+")")
			write_line("set_modal(" + modal + ")")
			if border_width /= Void then
				write_line("set_border_width("+border_width+")")
			end
			code.clear
			append_signal_code(code, "Current")
			write_lines(code)
			from
				i := 0
			until
				i >= vbox_widgets.count
			loop
				temp_child ?= vbox_widgets @ i
				if temp_child /= Void then
					!!code.make(0,-1);
					(vbox_widgets @ i).append_parent_creation(code)
					write_lines(code)
					write_line("vbox.pack("+(vbox_widgets @ i).name+", "+
						temp_child.boolean_property("expand") + ", " + 
						temp_child.boolean_property("fill") + ", " +
						temp_child.property("padding") + ")")
				end
				i := i + 1
			end
			from
				i := 0
			until
				i >= action_area_widgets.count
			loop
				temp_child ?= action_area_widgets @ i
				if temp_child /= Void then
					!!code.make(0,-1);
					(action_area_widgets @ i).append_parent_creation(code)
					write_lines(code)
					write_line("action_area.pack("+(action_area_widgets @ i).name+", "+
						temp_child.boolean_property("expand") + ", " + 
						temp_child.boolean_property("fill") + ", " +
						temp_child.property("padding") + ")")
				end
				i := i + 1
			end
			outdent
			write_line("end")
			outdent
		end
end
