use strict;
use Carp;
require 5.001;

package Dpkg::Package::Package;

sub new {
    my $this = shift;
    my $class = ref ($this) || $this;
    my %args = @_;

    my $self = {};

    if (! defined $args{'data'}) { 
	die ("requires 'data' as parameter"); 
    }

    bless ($self, $class);

    $self->parse ('data' => $args{'data'});
    return $self;
}

sub parse {
    my $self = shift;
    my %args = @_;

    if (! $args{'data'}) { 
	die ("requires 'data' as parameter"); 
    }
    my $data = $args{'data'};

    chomp ($data);

    $data =~ s/\n\s+/\376\377/g; # fix continuation lines
    $data =~ s/\376\377\s*\376\377/\376\377/og;

    while ($data =~ m/^(\S+):\s*(.*)\s*$/mg) {
	my ($key, $value) = ($1, $2);
	$key =~ tr [A-Z] [a-z];
	$value =~ s/\376\377/\n /g;
	$self->{$key} = $value;
    }
}

sub canon_version {
    my $self = shift;

    my $r = $self->{'version'};
    if (defined ($self->{'revision'}) && defined ($self->{'package_revision'})) {
	die ("package has both revision and package_revision entries");
    }
    if (defined ($self->{'package_revision'})) {
	$r = $r . $self->{'package_revision'};
    }
    if (defined ($self->{'revision'})) {
	$r = $r . $self->{'revision'};
    }
    return $r;
}

sub canon_name {
    my $self = shift;
    return $self->{'package'} . "_" . $self->canon_version () . "_" . $self->{'architecture'};
}
