(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 init.ml                                  *)
(****************************************************************************)

type mL_token = Use_module of string

type spec = bool

type coq_token = Require of spec * string
               | RequireString of spec * string
               | Declare of string list

let mlAccu  = ref ([] : (string * string * string option) list) and 
    mliAccu = ref ([] : (string * string * string option) list) and
    vAccu   = ref ([] : (string * string option) list)

let mlKnown     = ref ([] : (string * string option) list) and 
    mliKnown    = ref ([] : (string * string option) list) and
    vKnown      = ref ([] : (string * string option) list) and
    coqlibKnown = ref ([] : (string * string option) list)

let coqlib = ref Coq_config.coqlib

let (dep_tab : (string,string list) Hashtbl.t) = Hashtbl.create 151

let addQueue q v = q := v :: !q

let file_name = function
    (s,None)     -> s 
  | (s,Some ".") -> s
  | (s,Some d)   -> Filename.concat d s


let change_lower s =
  let s' = String.copy s in
  if s' <> "" then s'.[0] <- Char.lowercase s'.[0];
  s'
