(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                DemoRing.v                                *)
(****************************************************************************)
(* $Id: DemoRing.v,v 1.2 1999/06/30 16:39:06 loiseleu Exp $ *)

Require ZArithRing.

Parameters x, y, z : Z.

Goal `x*x + 2*x -x  = (x + 1)*x`.
Ring.
Save test0.

Goal `0 + z = 2*z + -z = z`.
Split; Ring.
Save test1.

Goal `0 + z + x =  x + z + 2*y - (y+y)`.
Unfold Zminus.
Ring.
Save test2.

Goal `4*x = x + 0 + x + 0 + x + x + 0`.
Ring.
Save test2bis.

Goal `0 + z + x =  x + z + 2*y - (y+y)`.
Require Omega.
Omega.
Save test2_omega. (* Comparer la taille des termes de preuve ! *)

Goal `x + y + 0 + 1*z +0 =  z + y + x +1 +1 -2`.
Ring.
Save test3.

Goal `(x + y)*(x + y) = x*x + y*y + x*y + y*x
       =  y*y + x*x + 2*x*y`.
Ring `(x + y)*(x + y)` `x*x + y*y + x*y + y*x` `y*y + x*x + 2*x*y`.
Auto.
Save test4.

Goal `x*x + x = x*(x+1) = (1+x)*x`.
Ring `x*x + x` `x*(x+1)` `(1+x)*x`.
Auto.
Save test5.

Goal `z=0` -> `z*(z + z*z*z + z*(z+z*(z*z))) = 0`.
Ring `z*(z + z*z*z + z*(z+z*(z*z)))`.
Intro; Rewrite H.
Trivial.
Save test6.

(* Exemple d'usage combin de Ring et Omega *)
Goal `12 + 13*4*(x + 45*(y + z + z)*3) = 12` -> `135*y + x + z*270 = 0`.
Ring `(x + 45*(y + z + z)*3)` `135*y + x + z*270`.
Generalize `270*z+(135*y+x)`.
Intro; Omega.
Save test7.

Goal (n,y:nat)(fact:nat->nat)
  (mult (plus y (mult n y)) (fact n))
    =(mult y (plus (fact n) (mult n (fact n)))).
Intros.
Ring.
Save test_jcf.


(* And now the big test *)
Goal (p1,q1,r1,s1,t1,u1,v1,w1,p2,q2,r2,s2,t2,u2,v2,w2:Z)
`(p1*p1 + q1*q1 + r1*r1 + s1*s1 + t1*t1 + u1*u1 + v1*v1 + w1*w1)*
 (p2*p2 + q2*q2 + r2*r2 + s2*s2 + t2*t2 + u2*u2 + v2*v2 + w2*w2)
=
(p1*p2 + (-q1*q2) + (-r1*r2) + (-s1*s2) + (-t1*t2) + (-u1*u2) + (-v1*v2) 
+ (-w1*w2))*(p1*p2 + (-q1*q2) + (-r1*r2) + (-s1*s2) + (-t1*t2) + (-u1*u2) + 
(-v1*v2) + (-w1*w2))
+
(p1*q2 + q1*p2 + r1*s2 + (-s1*r2) + t1*u2 + (-u1*t2) + (-v1*w2) + w1*v2)*
(p1*q2 + q1*p2 + r1*s2 + (-s1*r2) + t1*u2 + (-u1*t2) + (-v1*w2) + w1*v2)
+
(p1*r2 + (-q1*s2) + r1*p2 + s1*q2 + t1*v2 + u1*w2 + (-v1*t2) + (-w1*u2))*
(p1*r2 + (-q1*s2) + r1*p2 + s1*q2 + t1*v2 + u1*w2 + (-v1*t2) + (-w1*u2))
+
(p1*s2 + q1*r2 + (-r1*q2) + s1*p2 + t1*w2 + (-u1*v2) + v1*u2 + (-w1*t2))*
(p1*s2 + q1*r2 + (-r1*q2) + s1*p2 + t1*w2 + (-u1*v2) + v1*u2 + (-w1*t2))
+
(p1*t2 + (-q1*u2) + (-r1*v2) + (-s1*w2) + t1*p2 + u1*q2 + v1*r2 + w1*s2)* 
(p1*t2 + (-q1*u2) + (-r1*v2) + (-s1*w2) + t1*p2 + u1*q2 + v1*r2 + w1*s2)
+
(p1*u2 + q1*t2 + (-r1*w2) + s1*v2 + (-t1*q2) + u1*p2 + (-v1*s2) + w1*r2)*
(p1*u2 + q1*t2 + (-r1*w2) + s1*v2 + (-t1*q2) + u1*p2 + (-v1*s2) + w1*r2)
+
(p1*v2 + q1*w2 + r1*t2 + (-s1*u2) + (-t1*r2) + u1*s2 + v1*p2 + (-w1*q2))*
(p1*v2 + q1*w2 + r1*t2 + (-s1*u2) + (-t1*r2) + u1*s2 + v1*p2 + (-w1*q2))
+
(p1*w2 + (-q1*v2) + r1*u2 + s1*t2 + (-t1*s2) + (-u1*r2) + v1*q2 + w1*p2)*
(p1*w2 + (-q1*v2) + r1*u2 + s1*t2 + (-t1*s2) + (-u1*r2) + v1*q2 + w1*p2) `.

Proof.
Intros.
Ring.
Save bigtest.



